/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class PrimeScenarioExampleServer {
    public void runPrimeScenario() {
        try {
            MasterServerSocket serverSocket = new MasterServerSocket(5555);
            ((ServerSocket)serverSocket).setSoTimeout(10000);
            Socket v2 = ((ServerSocket)serverSocket).accept();
            AsynchronousThread asynchronousThread = new AsynchronousThread(v2);
            asynchronousThread.start();
            ObjectInputStream ois = new ObjectInputStream(v2.getInputStream());
            ObjectOutputStream oos = new ObjectOutputStream(v2.getOutputStream());
            v2.setSoTimeout(10000);
            Object o = ois.readObject();
            oos.writeObject(o);
            asynchronousThread.join();
            ((ServerSocket)serverSocket).close();
            v2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new PrimeScenarioExampleServer().runPrimeScenario();
    }

    class AsynchronousThread
    extends Thread {
        private Socket virtualSocket;

        public AsynchronousThread(Socket socket) throws IOException {
            this.virtualSocket = socket;
        }

        public void run() {
            try {
                Thread.sleep(2000L);
                String hostName = this.virtualSocket.getInetAddress().getHostName();
                int port = this.virtualSocket.getPort();
                VirtualSocket v3 = new VirtualSocket(hostName, port);
                ObjectOutputStream oos = new ObjectOutputStream(((Socket)v3).getOutputStream());
                oos.writeObject(new Integer(7));
                oos.flush();
                ((Socket)v3).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

