/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class CriteriaQueryTranslator
implements CriteriaQuery {
    public static final String ROOT_SQL_ALIAS = "this_";
    private CriteriaQuery outerQueryTranslator;
    private final CriteriaImpl rootCriteria;
    private final String rootEntityName;
    private final String rootSQLAlias;
    private int aliasCount = 0;
    private final Map criteriaEntityNames = new LinkedHashMap();
    private final Map criteriaSQLAliasMap = new HashMap();
    private final Map aliasCriteriaMap = new HashMap();
    private final Map associationPathCriteriaMap = new LinkedHashMap();
    private final Map associationPathJoinTypesMap = new LinkedHashMap();
    private final SessionFactoryImplementor sessionFactory;

    public CriteriaQueryTranslator(SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, String rootSQLAlias, CriteriaQuery outerQuery) throws HibernateException {
        this(factory, criteria, rootEntityName, rootSQLAlias);
        this.outerQueryTranslator = outerQuery;
    }

    public CriteriaQueryTranslator(SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, String rootSQLAlias) throws HibernateException {
        this.rootCriteria = criteria;
        this.rootEntityName = rootEntityName;
        this.sessionFactory = factory;
        this.rootSQLAlias = rootSQLAlias;
        this.createAliasCriteriaMap();
        this.createAssociationPathCriteriaMap();
        this.createCriteriaEntityNameMap();
        this.createCriteriaSQLAliasMap();
    }

    public String generateSQLAlias() {
        return StringHelper.generateAlias("this", this.aliasCount) + '_';
    }

    public String getRootSQLALias() {
        return this.rootSQLAlias;
    }

    private Criteria getAliasedCriteria(String alias) {
        return (Criteria)this.aliasCriteriaMap.get(alias);
    }

    public boolean isJoin(String path) {
        return this.associationPathCriteriaMap.containsKey(path);
    }

    public int getJoinType(String path) {
        Integer result = (Integer)this.associationPathJoinTypesMap.get(path);
        return result == null ? 0 : result;
    }

    public Criteria getCriteria(String path) {
        return (Criteria)this.associationPathCriteriaMap.get(path);
    }

    public Set getQuerySpaces() {
        HashSet<Serializable> result = new HashSet<Serializable>();
        Iterator iter = this.criteriaEntityNames.values().iterator();
        while (iter.hasNext()) {
            String entityName = (String)iter.next();
            result.addAll(Arrays.asList(this.getFactory().getEntityPersister(entityName).getQuerySpaces()));
        }
        return result;
    }

    private void createAliasCriteriaMap() {
        this.aliasCriteriaMap.put(this.rootCriteria.getAlias(), this.rootCriteria);
        Iterator iter = this.rootCriteria.iterateSubcriteria();
        while (iter.hasNext()) {
            Criteria old;
            Criteria subcriteria = (Criteria)iter.next();
            if (subcriteria.getAlias() == null || (old = this.aliasCriteriaMap.put(subcriteria.getAlias(), subcriteria)) == null) continue;
            throw new QueryException("duplicate alias: " + subcriteria.getAlias());
        }
    }

    private void createAssociationPathCriteriaMap() {
        Iterator iter = this.rootCriteria.iterateSubcriteria();
        while (iter.hasNext()) {
            CriteriaImpl.Subcriteria crit = (CriteriaImpl.Subcriteria)iter.next();
            String wholeAssociationPath = this.getWholeAssociationPath(crit);
            Serializable old = this.associationPathCriteriaMap.put(wholeAssociationPath, crit);
            if (old != null) {
                throw new QueryException("duplicate association path: " + wholeAssociationPath);
            }
            int joinType = crit.getJoinType();
            old = this.associationPathJoinTypesMap.put(wholeAssociationPath, new Integer(joinType));
            if (old == null) continue;
            throw new QueryException("duplicate association path: " + wholeAssociationPath);
        }
    }

    private String getWholeAssociationPath(CriteriaImpl.Subcriteria subcriteria) {
        String testAlias;
        String path = subcriteria.getPath();
        Criteria parent = null;
        if (path.indexOf(46) > 0 && !(testAlias = StringHelper.root(path)).equals(subcriteria.getAlias())) {
            parent = (Criteria)this.aliasCriteriaMap.get(testAlias);
        }
        if (parent == null) {
            parent = subcriteria.getParent();
        } else {
            path = StringHelper.unroot(path);
        }
        if (parent.equals(this.rootCriteria)) {
            return path;
        }
        return this.getWholeAssociationPath((CriteriaImpl.Subcriteria)parent) + '.' + path;
    }

    private void createCriteriaEntityNameMap() {
        this.criteriaEntityNames.put(this.rootCriteria, this.rootEntityName);
        Iterator iter = this.associationPathCriteriaMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            this.criteriaEntityNames.put(me.getValue(), this.getPathEntityName((String)me.getKey()));
        }
    }

    private String getPathEntityName(String path) {
        Queryable persister = (Queryable)this.sessionFactory.getEntityPersister(this.rootEntityName);
        StringTokenizer tokens = new StringTokenizer(path, ".");
        String componentPath = "";
        while (tokens.hasMoreTokens()) {
            Type type = persister.toType(componentPath = componentPath + tokens.nextToken());
            if (type.isAssociationType()) {
                AssociationType atype = (AssociationType)type;
                persister = (Queryable)this.sessionFactory.getEntityPersister(atype.getAssociatedEntityName(this.sessionFactory));
                componentPath = "";
                continue;
            }
            if (type.isComponentType()) {
                componentPath = componentPath + '.';
                continue;
            }
            throw new QueryException("not an association: " + componentPath);
        }
        return persister.getEntityName();
    }

    public int getSQLAliasCount() {
        return this.criteriaSQLAliasMap.size();
    }

    private void createCriteriaSQLAliasMap() {
        int i = 0;
        Iterator criteriaIterator = this.criteriaEntityNames.entrySet().iterator();
        while (criteriaIterator.hasNext()) {
            Map.Entry me = criteriaIterator.next();
            Criteria crit = (Criteria)me.getKey();
            String alias = crit.getAlias();
            if (alias == null) {
                alias = (String)me.getValue();
            }
            this.criteriaSQLAliasMap.put(crit, StringHelper.generateAlias(alias, i++));
        }
        this.criteriaSQLAliasMap.put(this.rootCriteria, this.rootSQLAlias);
    }

    public CriteriaImpl getRootCriteria() {
        return this.rootCriteria;
    }

    public QueryParameters getQueryParameters() {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator iter = this.rootCriteria.iterateExpressionEntries();
        while (iter.hasNext()) {
            CriteriaImpl.CriterionEntry ce = (CriteriaImpl.CriterionEntry)iter.next();
            TypedValue[] tv = ce.getCriterion().getTypedValues(ce.getCriteria(), this);
            for (int i = 0; i < tv.length; ++i) {
                values.add(tv[i].getValue());
                types.add(tv[i].getType());
            }
        }
        Object[] valueArray = values.toArray();
        Type[] typeArray = ArrayHelper.toTypeArray(types);
        RowSelection selection = new RowSelection();
        selection.setFirstRow(this.rootCriteria.getFirstResult());
        selection.setMaxRows(this.rootCriteria.getMaxResults());
        selection.setTimeout(this.rootCriteria.getTimeout());
        selection.setFetchSize(this.rootCriteria.getFetchSize());
        HashMap lockModes = new HashMap();
        iter = this.rootCriteria.getLockModes().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            Criteria subcriteria = this.getAliasedCriteria((String)me.getKey());
            lockModes.put(this.getSQLAlias(subcriteria), me.getValue());
        }
        iter = this.rootCriteria.iterateSubcriteria();
        while (iter.hasNext()) {
            CriteriaImpl.Subcriteria subcriteria = (CriteriaImpl.Subcriteria)iter.next();
            LockMode lm = subcriteria.getLockMode();
            if (lm == null) continue;
            lockModes.put(this.getSQLAlias(subcriteria), lm);
        }
        return new QueryParameters(typeArray, valueArray, lockModes, selection, this.rootCriteria.getCacheable(), this.rootCriteria.getCacheRegion(), this.rootCriteria.getComment(), this.rootCriteria.isLookupByNaturalKey(), this.rootCriteria.getResultTransformer());
    }

    public boolean hasProjection() {
        return this.rootCriteria.getProjection() != null;
    }

    public String getGroupBy() {
        if (this.rootCriteria.getProjection().isGrouped()) {
            return this.rootCriteria.getProjection().toGroupSqlString(this.rootCriteria.getProjectionCriteria(), this);
        }
        return "";
    }

    public String getSelect() {
        return this.rootCriteria.getProjection().toSqlString(this.rootCriteria.getProjectionCriteria(), 0, this);
    }

    public Type[] getProjectedTypes() {
        return this.rootCriteria.getProjection().getTypes(this.rootCriteria, this);
    }

    public String[] getProjectedColumnAliases() {
        return this.rootCriteria.getProjection().getColumnAliases(0);
    }

    public String[] getProjectedAliases() {
        return this.rootCriteria.getProjection().getAliases();
    }

    public String getWhereCondition() {
        StringBuffer condition = new StringBuffer(30);
        Iterator criterionIterator = this.rootCriteria.iterateExpressionEntries();
        while (criterionIterator.hasNext()) {
            CriteriaImpl.CriterionEntry entry = (CriteriaImpl.CriterionEntry)criterionIterator.next();
            String sqlString = entry.getCriterion().toSqlString(entry.getCriteria(), this);
            condition.append(sqlString);
            if (!criterionIterator.hasNext()) continue;
            condition.append(" and ");
        }
        return condition.toString();
    }

    public String getOrderBy() {
        StringBuffer orderBy = new StringBuffer(30);
        Iterator criterionIterator = this.rootCriteria.iterateOrderings();
        while (criterionIterator.hasNext()) {
            CriteriaImpl.OrderEntry oe = (CriteriaImpl.OrderEntry)criterionIterator.next();
            orderBy.append(oe.getOrder().toSqlString(oe.getCriteria(), this));
            if (!criterionIterator.hasNext()) continue;
            orderBy.append(", ");
        }
        return orderBy.toString();
    }

    public SessionFactoryImplementor getFactory() {
        return this.sessionFactory;
    }

    public String getSQLAlias(Criteria criteria) {
        return (String)this.criteriaSQLAliasMap.get(criteria);
    }

    public String getEntityName(Criteria criteria) {
        return (String)this.criteriaEntityNames.get(criteria);
    }

    public String getColumn(Criteria criteria, String propertyName) {
        String[] cols = this.getColumns(propertyName, criteria);
        if (cols.length != 1) {
            throw new QueryException("property does not map to a single column: " + propertyName);
        }
        return cols[0];
    }

    public String[] getColumnsUsingProjection(Criteria subcriteria, String propertyName) throws HibernateException {
        String[] projectionColumns;
        Projection projection = this.rootCriteria.getProjection();
        String[] stringArray = projectionColumns = projection == null ? null : projection.getColumnAliases(propertyName, 0);
        if (projectionColumns == null) {
            try {
                return this.getColumns(propertyName, subcriteria);
            }
            catch (HibernateException he) {
                if (this.outerQueryTranslator != null) {
                    return this.outerQueryTranslator.getColumnsUsingProjection(subcriteria, propertyName);
                }
                throw he;
            }
        }
        return projectionColumns;
    }

    public String[] getIdentifierColumns(Criteria subcriteria) {
        String[] idcols = ((Loadable)((Object)this.getPropertyMapping(this.getEntityName(subcriteria)))).getIdentifierColumnNames();
        return StringHelper.qualify(this.getSQLAlias(subcriteria), idcols);
    }

    public Type getIdentifierType(Criteria subcriteria) {
        return ((Loadable)((Object)this.getPropertyMapping(this.getEntityName(subcriteria)))).getIdentifierType();
    }

    public TypedValue getTypedIdentifierValue(Criteria subcriteria, Object value) {
        Loadable loadable = (Loadable)((Object)this.getPropertyMapping(this.getEntityName(subcriteria)));
        return new TypedValue(loadable.getIdentifierType(), value, EntityMode.POJO);
    }

    private String[] getColumns(String propertyName, Criteria subcriteria) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(subcriteria, propertyName)).toColumns(this.getSQLAlias(subcriteria, propertyName), this.getPropertyName(propertyName));
    }

    public Type getTypeUsingProjection(Criteria subcriteria, String propertyName) throws HibernateException {
        Type[] projectionTypes;
        Projection projection = this.rootCriteria.getProjection();
        Type[] typeArray = projectionTypes = projection == null ? null : projection.getTypes(propertyName, subcriteria, this);
        if (projectionTypes == null) {
            try {
                return this.getType(subcriteria, propertyName);
            }
            catch (HibernateException he) {
                if (this.outerQueryTranslator != null) {
                    return this.outerQueryTranslator.getType(subcriteria, propertyName);
                }
                throw he;
            }
        }
        if (projectionTypes.length != 1) {
            throw new QueryException("not a single-length projection: " + propertyName);
        }
        return projectionTypes[0];
    }

    public Type getType(Criteria subcriteria, String propertyName) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(subcriteria, propertyName)).toType(this.getPropertyName(propertyName));
    }

    public TypedValue getTypedValue(Criteria subcriteria, String propertyName, Object value) throws HibernateException {
        Class entityClass;
        Queryable q;
        if (value instanceof Class && (q = SessionFactoryHelper.findQueryableUsingImports(this.sessionFactory, (entityClass = (Class)value).getName())) != null) {
            Type type = q.getDiscriminatorType();
            String stringValue = q.getDiscriminatorSQLValue();
            if (!(type instanceof NullableType)) {
                throw new QueryException("Unsupported discriminator type " + type);
            }
            NullableType nullableType = (NullableType)type;
            value = nullableType.fromStringValue(stringValue);
            return new TypedValue(type, value, EntityMode.POJO);
        }
        return new TypedValue(this.getTypeUsingProjection(subcriteria, propertyName), value, EntityMode.POJO);
    }

    private PropertyMapping getPropertyMapping(String entityName) throws MappingException {
        return (PropertyMapping)((Object)this.sessionFactory.getEntityPersister(entityName));
    }

    public String getEntityName(Criteria subcriteria, String propertyName) {
        String root;
        Criteria crit;
        if (propertyName.indexOf(46) > 0 && (crit = this.getAliasedCriteria(root = StringHelper.root(propertyName))) != null) {
            return this.getEntityName(crit);
        }
        return this.getEntityName(subcriteria);
    }

    public String getSQLAlias(Criteria criteria, String propertyName) {
        String root;
        Criteria subcriteria;
        if (propertyName.indexOf(46) > 0 && (subcriteria = this.getAliasedCriteria(root = StringHelper.root(propertyName))) != null) {
            return this.getSQLAlias(subcriteria);
        }
        return this.getSQLAlias(criteria);
    }

    public String getPropertyName(String propertyName) {
        String root;
        Criteria crit;
        if (propertyName.indexOf(46) > 0 && (crit = this.getAliasedCriteria(root = StringHelper.root(propertyName))) != null) {
            return propertyName.substring(root.length() + 1);
        }
        return propertyName;
    }
}

