/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeDataHierarchyHolder {
    private static final Log LOG = ExoLogger.getLogger(NodeTypeDataHierarchyHolder.class);
    private final Map<InternalQName, NodeTypeHolder> nodeTypes;

    public NodeTypeDataHierarchyHolder() {
        this.nodeTypes = new ConcurrentHashMap<InternalQName, NodeTypeHolder>();
    }

    public NodeTypeDataHierarchyHolder(Map<InternalQName, NodeTypeHolder> nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public List<NodeTypeData> getAllNodeTypes() {
        Collection<NodeTypeHolder> hs = this.nodeTypes.values();
        ArrayList<NodeTypeData> nts = new ArrayList<NodeTypeData>(hs.size());
        for (NodeTypeHolder nt : hs) {
            nts.add(nt.nodeType);
        }
        return nts;
    }

    public Set<InternalQName> getDeclaredSubtypes(InternalQName nodeTypeName) {
        HashSet<InternalQName> resultSet = new HashSet<InternalQName>();
        for (Map.Entry<InternalQName, NodeTypeHolder> entry : this.nodeTypes.entrySet()) {
            InternalQName[] declaredSupertypeNames = entry.getValue().nodeType.getDeclaredSupertypeNames();
            for (int i = 0; i < declaredSupertypeNames.length; ++i) {
                if (!nodeTypeName.equals((Object)declaredSupertypeNames[i])) continue;
                resultSet.add(entry.getKey());
            }
        }
        return resultSet;
    }

    public NodeTypeData getNodeType(InternalQName nodeTypeName) {
        NodeTypeHolder nt;
        if (nodeTypeName != null && (nt = this.nodeTypes.get((Object)nodeTypeName)) != null) {
            return nt.nodeType;
        }
        return null;
    }

    public NodeTypeData getNodeType(InternalQName nodeTypeName, Map<InternalQName, NodeTypeData> volatileNodeTypes) {
        NodeTypeData nt = volatileNodeTypes.get((Object)nodeTypeName);
        if (nt == null) {
            NodeTypeHolder nth = this.nodeTypes.get((Object)nodeTypeName);
            nt = nth != null ? nth.nodeType : null;
        }
        return nt;
    }

    public Set<InternalQName> getSubtypes(InternalQName nodeTypeName) {
        HashSet<InternalQName> resultSet = new HashSet<InternalQName>();
        for (InternalQName ntName : this.nodeTypes.keySet()) {
            if (!this.getSupertypes(ntName).contains((Object)nodeTypeName)) continue;
            resultSet.add(ntName);
        }
        return resultSet;
    }

    public Set<InternalQName> getSupertypes(InternalQName nodeTypeName) {
        NodeTypeHolder nt;
        if (nodeTypeName != null && (nt = this.nodeTypes.get((Object)nodeTypeName)) != null) {
            return nt.superTypes;
        }
        return new HashSet<InternalQName>();
    }

    public Set<InternalQName> getSupertypes(InternalQName nodeTypeName, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        NodeTypeHolder nt = this.nodeTypes.get((Object)nodeTypeName);
        if (nt == null) {
            throw new RepositoryException("Node type " + nodeTypeName.getAsString() + " not found");
        }
        HashSet<InternalQName> supers = new HashSet<InternalQName>();
        this.mergeAllSupertypes(supers, nt.nodeType.getDeclaredSupertypeNames(), volatileNodeTypes);
        return supers;
    }

    public boolean isNodeType(InternalQName testTypeName, InternalQName ... typesNames) {
        for (InternalQName typeName : typesNames) {
            if (testTypeName.equals((Object)typeName)) {
                return true;
            }
            NodeTypeHolder nt = this.nodeTypes.get((Object)typeName);
            if (nt == null || !nt.superTypes.contains((Object)testTypeName)) continue;
            return true;
        }
        return false;
    }

    void addNodeType(NodeTypeData nodeType, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        HashSet<InternalQName> supers = new HashSet<InternalQName>();
        this.mergeAllSupertypes(supers, nodeType.getDeclaredSupertypeNames(), volatileNodeTypes);
        this.nodeTypes.put(nodeType.getName(), new NodeTypeHolder(nodeType, supers));
    }

    void removeNodeType(InternalQName nodeTypeName) {
        this.nodeTypes.remove((Object)nodeTypeName);
    }

    protected synchronized void mergeAllSupertypes(Set<InternalQName> list, InternalQName[] supers, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        if (supers != null) {
            for (InternalQName su : supers) {
                if (list.contains((Object)su)) continue;
                list.add(su);
                NodeTypeData volatileSuper = volatileNodeTypes.get((Object)su);
                NodeTypeHolder ntSuper = this.nodeTypes.get((Object)su);
                if (volatileSuper == null && ntSuper == null) {
                    throw new RepositoryException("Node type " + su.getAsString() + " not found");
                }
                if (volatileSuper != null) {
                    this.mergeAllSupertypes(list, volatileSuper.getDeclaredSupertypeNames(), volatileNodeTypes);
                    continue;
                }
                this.mergeAllSupertypes(list, ntSuper.superTypes.toArray(new InternalQName[ntSuper.superTypes.size()]), volatileNodeTypes);
            }
        }
    }

    protected NodeTypeDataHierarchyHolder createCopy() {
        return new NodeTypeDataHierarchyHolder(new ConcurrentHashMap<InternalQName, NodeTypeHolder>(this.nodeTypes));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeTypeHolder {
        final NodeTypeData nodeType;
        final Set<InternalQName> superTypes;

        NodeTypeHolder(NodeTypeData nodeType, Set<InternalQName> superTypes) {
            this.nodeType = nodeType;
            this.superTypes = superTypes;
        }
    }
}

