/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.AbstractProcessor;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BoundProviderFactory;
import com.google.inject.ConstantFactory;
import com.google.inject.ExposedKeyFactory;
import com.google.inject.FactoryProxy;
import com.google.inject.Initializable;
import com.google.inject.Initializer;
import com.google.inject.Injector;
import com.google.inject.InjectorImpl;
import com.google.inject.InternalFactoryToProviderAdapter;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ExposedBindingImpl;
import com.google.inject.internal.ImmutableSet;
import com.google.inject.internal.InstanceBindingImpl;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.LinkedBindingImpl;
import com.google.inject.internal.LinkedProviderBindingImpl;
import com.google.inject.internal.Lists;
import com.google.inject.internal.ProviderInstanceBindingImpl;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.Scoping;
import com.google.inject.internal.UntargettedBindingImpl;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BindingProcessor
extends AbstractProcessor {
    private final List<CreationListener> creationListeners = Lists.newArrayList();
    private final Initializer initializer;
    private final List<Runnable> uninitializedBindings = Lists.newArrayList();
    private static final Set<Class<?>> FORBIDDEN_TYPES = ImmutableSet.of(new Class[]{AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class});

    BindingProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        final Object source = command.getSource();
        if (Void.class.equals(command.getKey().getRawType())) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getProviderInstance() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        final Key<T> key = command.getKey();
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        this.validateKey(command.getSource(), command.getKey());
        final Scoping scoping = Scopes.makeInjectable(((BindingImpl)command).getScoping(), this.injector, this.errors);
        command.acceptTargetVisitor(new BindingTargetVisitor<T, Void>(){

            @Override
            public Void visit(InstanceBinding<? extends T> binding) {
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, injectionPoints, instance));
                return null;
            }

            @Override
            public Void visit(ProviderInstanceBinding<? extends T> binding) {
                Provider provider = binding.getProviderInstance();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, source, injectionPoints);
                InternalFactoryToProviderAdapter factory = new InternalFactoryToProviderAdapter(initializable, source);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, provider, injectionPoints));
                return null;
            }

            @Override
            public Void visit(ProviderKeyBinding<? extends T> binding) {
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, source);
                BindingProcessor.this.creationListeners.add(boundProviderFactory);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, boundProviderFactory, scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, providerKey));
                return null;
            }

            @Override
            public Void visit(LinkedKeyBinding<? extends T> binding) {
                Key linkedKey = binding.getLinkedKey();
                if (key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, key, linkedKey, source);
                BindingProcessor.this.creationListeners.add(factory);
                InternalFactory scopedFactory = Scopes.scope(key, BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, linkedKey));
                return null;
            }

            @Override
            public Void visit(UntargettedBinding<? extends T> untargetted) {
                BindingImpl binding;
                if (key.hasAnnotationType()) {
                    BindingProcessor.this.errors.missingImplementation(key);
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                try {
                    binding = BindingProcessor.this.injector.createUnitializedBinding(key, scoping, source, BindingProcessor.this.errors);
                    BindingProcessor.this.putBinding(binding);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                BindingProcessor.this.uninitializedBindings.add(new Runnable(){

                    public void run() {
                        try {
                            ((InjectorImpl)binding.getInjector()).initializeBinding(binding, BindingProcessor.this.errors.withSource(source));
                        }
                        catch (ErrorsException e) {
                            BindingProcessor.this.errors.merge(e.getErrors());
                        }
                    }
                });
                return null;
            }

            @Override
            public Void visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConstructorBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }
        });
        return true;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.creationListeners.add(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>((Injector)this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }

    private <T> void validateKey(Object source, Key<T> key) {
        Annotations.checkForMisplacedScopeAnnotations(key.getRawType(), source, this.errors);
    }

    <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key, Object source) {
        return new UntargettedBindingImpl<T>(injector, key, source);
    }

    public void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    public void runCreationListeners() {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.errors);
        }
    }

    private void putBinding(BindingImpl<?> binding) {
        Key<?> key = binding.getKey();
        Class<?> rawType = key.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.errors.cannotBindToGuiceType(rawType.getSimpleName());
            return;
        }
        BindingImpl<?> original = this.injector.state.getExplicitBinding(key);
        if (original != null && !this.isOkayDuplicate(original, binding)) {
            this.errors.bindingAlreadySet(key, original.getSource());
            return;
        }
        this.injector.state.parent().blacklist(key);
        this.injector.state.putBinding(key, binding);
    }

    private boolean isOkayDuplicate(Binding<?> original, BindingImpl<?> binding) {
        if (original instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposed = (ExposedBindingImpl)original;
            InjectorImpl exposedFrom = (InjectorImpl)exposed.getPrivateElements().getInjector();
            return exposedFrom == binding.getInjector();
        }
        return false;
    }

    static interface CreationListener {
        public void notify(Errors var1);
    }
}

