/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public class DefaultLoginModule
extends AbstractLoginModule {
    protected Log log = ExoLogger.getLogger((String)"core.DefaultLoginModule");
    protected Identity identity;
    protected boolean singleLogin;

    public void afterInitialize() {
        String sl = (String)this.options.get("singleLogin");
        this.singleLogin = sl != null && (sl.equalsIgnoreCase("yes") || sl.equalsIgnoreCase("true"));
    }

    public boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In login of DefaultLoginModule.");
        }
        try {
            if (this.sharedState.containsKey("exo.security.identity")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Use Identity from previous LoginModule");
                }
                this.identity = (Identity)this.sharedState.get("exo.security.identity");
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Try create identity");
                }
                Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
                this.callbackHandler.handle(callbacks);
                String username = ((NameCallback)callbacks[0]).getName();
                String password = new String(((PasswordCallback)callbacks[1]).getPassword());
                ((PasswordCallback)callbacks[1]).clearPassword();
                if (username == null || password == null) {
                    return false;
                }
                Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                if (authenticator == null) {
                    throw new LoginException("No Authenticator component found, check your configuration");
                }
                Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
                String userId = authenticator.validateUser(credentials);
                this.identity = authenticator.createIdentity(userId);
                this.sharedState.put("javax.security.auth.login.name", userId);
                this.subject.getPrivateCredentials().add(password);
                this.subject.getPublicCredentials().add(new UsernameCredential(username));
            }
            return true;
        }
        catch (Throwable e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new LoginException(e.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        try {
            IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
            if (this.singleLogin && identityRegistry.getIdentity(this.identity.getUserId()) != null) {
                throw new LoginException("User " + this.identity.getUserId() + " already logined.");
            }
            this.identity.setSubject(this.subject);
            identityRegistry.register(this.identity);
        }
        catch (Throwable e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new LoginException(e.getMessage());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In abort of DefaultLoginModule.");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In logout of DefaultLoginModule.");
        }
        return true;
    }

    protected Log getLogger() {
        return this.log;
    }
}

