/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal;

import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerLoaderConstants;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;

public class MarshallerLoaderClient
implements MarshallerLoaderConstants {
    protected static final Logger log = Logger.getLogger(MarshallerLoaderClient.class);

    public static Marshaller getMarshaller(InvokerLocator loaderLocator, String dataType, ClassLoader classByteLoader) {
        Marshaller marshaller = null;
        try {
            SerializableMarshaller loaderMarshaller = new SerializableMarshaller();
            SerializableUnMarshaller loaderUnMarshaller = new SerializableUnMarshaller();
            loaderUnMarshaller.setClassLoader(classByteLoader);
            String marshallerMethodName = "get_marshaller";
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("datatype", dataType);
            Client loaderClient = new Client(loaderLocator);
            loaderClient.connect();
            loaderClient.setMarshaller(loaderMarshaller);
            loaderClient.setUnMarshaller(loaderUnMarshaller);
            Object obj = null;
            obj = loaderClient.invoke(marshallerMethodName, metadata);
            if (obj != null) {
                marshaller = (Marshaller)obj;
            }
        }
        catch (Throwable e) {
            log.error("Error creating remoting client to connect to marhsaller loader.", e);
        }
        if (marshaller == null) {
            log.error("Can not load marshall for loader locator " + loaderLocator + ".");
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(InvokerLocator loaderLocator, String dataType, ClassLoader classByteLoader) {
        UnMarshaller unmarshaller = null;
        try {
            SerializableMarshaller loaderMarshaller = new SerializableMarshaller();
            SerializableUnMarshaller loaderUnMarshaller = new SerializableUnMarshaller();
            loaderUnMarshaller.setClassLoader(classByteLoader);
            String marshallerMethodName = "get_unmarshaller";
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("datatype", dataType);
            Client loaderClient = new Client(loaderLocator);
            loaderClient.connect();
            loaderClient.setMarshaller(loaderMarshaller);
            loaderClient.setUnMarshaller(loaderUnMarshaller);
            Object obj = null;
            obj = loaderClient.invoke(marshallerMethodName, metadata);
            if (obj != null) {
                unmarshaller = (UnMarshaller)obj;
            }
        }
        catch (Throwable e) {
            log.error("Error creating remoting client to connecto to marhsaller loader.", e);
        }
        if (unmarshaller == null) {
            log.error("Can not load unmarshaller for loader locator " + loaderLocator + ".");
        }
        return unmarshaller;
    }
}

