/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;

public class COMPRESS
extends Protocol {
    BlockingQueue<Deflater> deflater_pool = null;
    BlockingQueue<Inflater> inflater_pool = null;
    int compression_level = 9;
    long min_size = 500L;
    int pool_size = 2;
    static final String name = "COMPRESS";

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        int i;
        this.deflater_pool = new ArrayBlockingQueue<Deflater>(this.pool_size);
        for (i = 0; i < this.pool_size; ++i) {
            this.deflater_pool.add(new Deflater(this.compression_level));
        }
        this.inflater_pool = new ArrayBlockingQueue<Inflater>(this.pool_size);
        for (i = 0; i < this.pool_size; ++i) {
            this.inflater_pool.add(new Inflater());
        }
    }

    public void destroy() {
        for (Deflater deflater : this.deflater_pool) {
            deflater.end();
        }
        for (Inflater inflater : this.inflater_pool) {
            inflater.end();
        }
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("compression_level");
        if (str != null) {
            this.compression_level = Integer.parseInt(str);
            props.remove("compression_level");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Long.parseLong(str);
            props.remove("min_size");
        }
        if ((str = props.getProperty("pool_size")) != null) {
            this.pool_size = Integer.parseInt(str);
            if (this.pool_size <= 0) {
                this.log.warn((Object)"pool_size must be > 0, setting it to 1");
                this.pool_size = 1;
            }
            props.remove("pool_size");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public Object down(Event evt) {
        Message msg;
        int length;
        if (evt.getType() == 1 && (long)(length = (msg = (Message)evt.getArg()).getLength()) >= this.min_size) {
            byte[] payload = msg.getRawBuffer();
            byte[] compressed_payload = new byte[length];
            Deflater deflater = null;
            try {
                deflater = this.deflater_pool.take();
                deflater.reset();
                deflater.setInput(payload, msg.getOffset(), length);
                deflater.finish();
                deflater.deflate(compressed_payload);
                int compressed_size = deflater.getTotalOut();
                if (compressed_size < length) {
                    byte[] new_payload = new byte[compressed_size];
                    System.arraycopy(compressed_payload, 0, new_payload, 0, compressed_size);
                    msg.setBuffer(new_payload);
                    msg.putHeader(name, new CompressHeader(length));
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("compressed payload from " + length + " bytes to " + compressed_size + " bytes"));
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Skipping compression since the compressed message is larger than the original");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            finally {
                if (deflater != null) {
                    this.deflater_pool.offer(deflater);
                }
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object up(Event evt) {
        block12: {
            byte[] compressed_payload;
            Message msg;
            CompressHeader hdr;
            if (evt.getType() == 1 && (hdr = (CompressHeader)(msg = (Message)evt.getArg()).getHeader(name)) != null && (compressed_payload = msg.getRawBuffer()) != null && compressed_payload.length > 0) {
                int original_size = hdr.original_size;
                byte[] uncompressed_payload = new byte[original_size];
                Inflater inflater = null;
                try {
                    inflater = this.inflater_pool.take();
                    inflater.reset();
                    inflater.setInput(compressed_payload, msg.getOffset(), msg.getLength());
                    try {
                        inflater.inflate(uncompressed_payload);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("uncompressed " + compressed_payload.length + " bytes to " + original_size + " bytes"));
                        }
                        Message copy = msg.copy(false);
                        copy.setBuffer(uncompressed_payload);
                        Object object = this.up_prot.up(new Event(1, copy));
                        return object;
                    }
                    catch (DataFormatException e) {
                        try {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"exception on uncompression", (Throwable)e);
                            }
                            if (inflater == null) break block12;
                            this.inflater_pool.offer(inflater);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                finally {
                    if (inflater != null) {
                        this.inflater_pool.offer(inflater);
                    }
                }
            }
        }
        return this.up_prot.up(evt);
    }

    public static class CompressHeader
    extends Header
    implements Streamable {
        int original_size = 0;

        public CompressHeader() {
        }

        public CompressHeader(int s) {
            this.original_size = s;
        }

        public int size() {
            return 4;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.original_size = in.readInt();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.original_size = in.readInt();
        }
    }
}

