/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.IOException;
import java.util.HashMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.invocation.MarshalledValue;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;

public class MarshalledTreeCache
extends TreeCache
implements TreeCacheListener {
    protected TreeCache localCopy_;
    protected String nodeId_;
    protected static final String NODEID_KEY = "__NODEID_KEY__";
    protected ClassLoader tcl_ = null;
    protected boolean useLocalOptimization_ = true;
    protected boolean marshalling_ = true;

    public MarshalledTreeCache(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        super(cluster_name, props, state_fetch_timeout);
        this._init();
    }

    public MarshalledTreeCache() throws Exception {
        this._init();
    }

    public MarshalledTreeCache(JChannel channel) throws Exception {
        super(channel);
        this._init();
    }

    private void _init() throws Exception {
        this.localCopy_ = new TreeCache();
        this.localCopy_.setCacheMode(1);
        this.localCopy_.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.marshalling_ = true;
        this.useLocalOptimization_ = true;
        this.tcl_ = null;
    }

    public void startService() throws Exception {
        super.addTreeCacheListener(this);
        super.startService();
        if (this.localCopy_ == null) {
            throw new RuntimeException("startService(): null localCopy_");
        }
        this.localCopy_.startService();
        this.obtainNodeId();
    }

    public void stopService() {
        this.nodeId_ = null;
        this.localCopy_.stopService();
        super.stopService();
    }

    protected void obtainNodeId() {
        IpAddress address = (IpAddress)this.getLocalAddress();
        if (address == null) {
            log.info((Object)"obtainNodeId(): has null IpAddress. Assume it is running in local mode.");
            this.nodeId_ = "local";
            return;
        }
        this.nodeId_ = address.getAdditionalData() == null ? address.getIpAddress().getHostAddress() + ":" + address.getPort() : new String(address.getAdditionalData());
    }

    public String getNodeId() {
        return this.nodeId_;
    }

    public void setMarshalling(boolean marshalling) {
        this.marshalling_ = marshalling;
    }

    public void setLocalOptimization(boolean optimization) {
        this.useLocalOptimization_ = optimization;
        throw new RuntimeException("MarshalledTreeCache.setLocalOptimization(): operation not supported yet.");
    }

    public void setClassLoader(ClassLoader tcl) {
        this.tcl_ = tcl;
    }

    public void marshalledPut(String fqn, Object key, Object value) throws CacheException {
        this.marshalledPut(Fqn.fromString(fqn), key, value);
    }

    public void marshalledPut(Fqn fqn, Object key, Object value) throws CacheException {
        if (this.marshalling_) {
            this.marshalledPut_(fqn, key, value);
        } else {
            this.put(fqn, key, value);
        }
    }

    public void marshalledPut_(Fqn fqn, Object key, Object value) throws CacheException {
        MarshalledValue mv = null;
        try {
            mv = new MarshalledValue(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CacheException("marshalledPut() exception: " + e);
        }
        this.localCopy_.put(fqn, key, value);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, mv);
        map.put(NODEID_KEY, this.nodeId_);
        this.put(fqn, map);
    }

    public Object marshalledGet(String fqn, Object key) throws CacheException {
        return this.marshalledGet(Fqn.fromString(fqn), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object marshalledGet(Fqn fqn, Object key) throws CacheException {
        if (this.marshalling_) {
            ClassLoader prevTCL = null;
            if (this.tcl_ != null) {
                prevTCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.tcl_);
            }
            try {
                Object object = this.marshalledGet_(fqn, key);
                return object;
            }
            finally {
                if (this.tcl_ != null && prevTCL != null) {
                    Thread.currentThread().setContextClassLoader(prevTCL);
                }
            }
        }
        return this.get(fqn, key);
    }

    public Object marshalledGet_(Fqn fqn, Object key) throws CacheException {
        try {
            Object value = this.localCopy_.get(fqn, key);
            if (value != null) {
                return value;
            }
            value = this.get(fqn, key);
            if (value == null) {
                return null;
            }
            this.checkValue(value);
            MarshalledValue mv = (MarshalledValue)value;
            value = mv.get();
            this.localCopy_.put(fqn, key, value);
            return value;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CacheException("marshalledGet(): exception encountered: ", e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CacheException("marshalledGet(): exception encountered: ", e);
        }
    }

    public Object marshalledRemove(String fqn, Object key) throws CacheException {
        return this.marshalledRemove(Fqn.fromString(fqn), key);
    }

    public Object marshalledRemove(Fqn fqn, Object key) throws CacheException {
        if (this.marshalling_) {
            return this.marshalledRemove_(fqn, key);
        }
        return this.remove(fqn, key);
    }

    public Object marshalledRemove_(Fqn fqn, Object key) throws CacheException {
        if (!this.exists(fqn, key)) {
            log.warn((Object)("marshalledRemove(): fqn: " + fqn + " key: " + key + " not found."));
        }
        Object value = this.localCopy_.get(fqn, key);
        this.localCopy_.remove(fqn);
        this.remove(fqn, (Object)NODEID_KEY);
        Object obj = this.remove(fqn, key);
        if (value != null) {
            return value;
        }
        this.checkValue(obj);
        try {
            return ((MarshalledValue)obj).get();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CacheException("marshalledRemove(): exception encountered: ", e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CacheException("marshalledRemove(): exception encountered: ", e);
        }
    }

    public void nodeCreated(Fqn fqn) {
    }

    public void nodeRemoved(Fqn fqn) {
        this.invalidate(fqn);
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeEvicted(Fqn fqn) {
        this.invalidate(fqn);
    }

    public void nodeModified(Fqn fqn) {
        this.invalidate(fqn);
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(View new_view) {
    }

    protected void checkValue(Object value) {
        if (value != null && !(value instanceof MarshalledValue)) {
            throw new RuntimeException("checkValue: return object is not instance of MarshalledValue. object: " + value);
        }
    }

    protected void invalidate(Fqn fqn) {
        if (!this.marshalling_) {
            return;
        }
        if (fqn.isRoot()) {
            return;
        }
        if (!this.localCopy_.exists(fqn)) {
            return;
        }
        try {
            String eventId = (String)this.get(fqn, (Object)NODEID_KEY);
            if (eventId == null) {
                throw new RuntimeException("invlidate(): fqn to invlidate has null node id. fqn: " + fqn);
            }
            if (this.nodeId_.equals(eventId)) {
                return;
            }
            this.localCopy_.remove(fqn);
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }
}

