/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.util.propertyeditor.PropertyEditors;

public class JMX
extends Task {
    private String serverURL;
    private String adapterName = "jmx/invoker/RMIAdaptor";
    private String username;
    private String password;
    private List ops = new ArrayList();
    private List editors = new ArrayList();

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setAdapterName(String adapterName) {
        this.adapterName = adapterName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addInvoke(Invoke invoke) {
        this.ops.add(invoke);
    }

    public void addSetAttribute(Setter setter) {
        this.ops.add(setter);
    }

    public void addGetAttribute(Getter getter) {
        this.ops.add(getter);
    }

    public void addPropertyEditor(PropertyEditorHolder peh) {
        this.editors.add(peh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                for (int i = 0; i < this.editors.size(); ++i) {
                    ((PropertyEditorHolder)this.editors.get(i)).execute();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("Could not register property editors: " + e);
            }
            try {
                Properties props = new Properties();
                String factory = "org.jnp.interfaces.NamingContextFactory";
                if (this.username != null && this.password != null) {
                    factory = "org.jboss.security.jndi.JndiLoginInitialContextFactory";
                    props.put("java.naming.security.principal", this.username);
                    props.put("java.naming.security.credentials", this.password);
                }
                props.put("java.naming.factory.initial", factory);
                props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                if (this.serverURL == null || "".equals(this.serverURL)) {
                    props.put("java.naming.provider.url", "jnp://localhost:1099");
                } else {
                    props.put("java.naming.provider.url", this.serverURL);
                }
                InitialContext ctx = new InitialContext(props);
                if (this.adapterName == null) {
                    this.adapterName = "jmx/rmi/RMIAdaptor";
                }
                Object obj = ctx.lookup(this.adapterName);
                ctx.close();
                if (!(obj instanceof MBeanServerConnection)) {
                    throw new ClassCastException("Object not of type: MBeanServerConnection, but: " + (obj == null ? "not found" : obj.getClass().getName()));
                }
                MBeanServerConnection server = (MBeanServerConnection)obj;
                for (int i = 0; i < this.ops.size(); ++i) {
                    Operation op = (Operation)this.ops.get(i);
                    op.execute(server, this);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("problem: " + e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    public static class PropertyEditorHolder {
        private String type;
        private String editor;

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        private Class getTypeClass() throws ClassNotFoundException {
            try {
                return Class.forName(this.type);
            }
            catch (ClassNotFoundException e) {
                try {
                    return this.getClass().getClassLoader().loadClass(this.type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Thread.currentThread().getContextClassLoader().loadClass(this.type);
                }
            }
        }

        public void setEditor(String editor) {
            this.editor = editor;
        }

        public String getEditor() {
            return this.editor;
        }

        private Class getEditorClass() throws ClassNotFoundException {
            try {
                return Class.forName(this.editor);
            }
            catch (ClassNotFoundException e) {
                try {
                    return this.getClass().getClassLoader().loadClass(this.editor);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Thread.currentThread().getContextClassLoader().loadClass(this.editor);
                }
            }
        }

        public void execute() throws ClassNotFoundException {
            PropertyEditorManager.registerEditor(this.getTypeClass(), this.getEditorClass());
        }
    }

    public static class Param {
        private String arg;
        private String type;

        public void setArg(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() throws Exception {
            PropertyEditor editor = PropertyEditors.getEditor((String)this.type);
            editor.setAsText(this.arg);
            return editor.getValue();
        }
    }

    public static class Getter
    implements Operation {
        private ObjectName target;
        private String attribute;
        private String property;

        public void setTarget(ObjectName target) {
            this.target = target;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void execute(MBeanServerConnection server, Task parent) throws Exception {
            Object result = server.getAttribute(this.target, this.attribute);
            if (this.property != null && result != null) {
                parent.getProject().setProperty(this.property, result.toString());
            }
        }
    }

    public static class Setter
    implements Operation {
        private ObjectName target;
        private String attribute;
        private Param value;

        public void setTarget(ObjectName target) {
            this.target = target;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public void setValue(Param value) {
            this.value = value;
        }

        public void execute(MBeanServerConnection server, Task parent) throws Exception {
            Attribute att = new Attribute(this.attribute, this.value.getValue());
            server.setAttribute(this.target, att);
        }
    }

    public static class Invoke
    implements Operation {
        private ObjectName target;
        private String property;
        private String operation;
        private List params = new ArrayList();

        public void setProperty(String property) {
            this.property = property;
        }

        public void setTarget(ObjectName target) {
            this.target = target;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void addParameter(Param param) {
            this.params.add(param);
        }

        public void execute(MBeanServerConnection server, Task parent) throws Exception {
            int paramCount = this.params.size();
            Object[] args = new Object[paramCount];
            String[] types = new String[paramCount];
            int pos = 0;
            for (int i = 0; i < this.params.size(); ++i) {
                Param p = (Param)this.params.get(i);
                args[pos] = p.getValue();
                types[pos] = p.getType();
                ++pos;
            }
            Object result = server.invoke(this.target, this.operation, args, types);
            if (this.property != null && result != null) {
                parent.getProject().setProperty(this.property, result.toString());
            }
        }
    }

    public static interface Operation {
        public void execute(MBeanServerConnection var1, Task var2) throws Exception;
    }
}

