/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.tools.interfaces.WebservicesXMLCreator;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;

public class WebservicesXMLCreatorImpl
implements WebservicesXMLCreator {
    protected static final Logger log = Logger.getLogger(WebservicesXMLCreatorImpl.class);
    protected String targetNamespace = null;
    protected String seiName = null;
    protected String portName = null;
    protected String serviceName = null;
    protected String servletLink = null;
    protected String ejbLink = null;
    protected String wsdlFile = null;
    protected String mappingFile = null;
    protected boolean append = false;

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setSeiName(String seiName) {
        this.seiName = seiName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }

    public void setServletLink(String servletLink) {
        this.servletLink = servletLink;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void generateWSXMLDescriptor(File wsXmlFile) throws IOException {
        WebservicesMetaData webservices = this.constructWSMetaData();
        if (this.append && wsXmlFile.exists()) {
            WebservicesMetaData existingWebservices;
            FileInputStream wsXmlStream = new FileInputStream(wsXmlFile);
            try {
                try {
                    Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                    WebservicesFactory factory = new WebservicesFactory(wsXmlFile.toURL());
                    existingWebservices = (WebservicesMetaData)unmarshaller.unmarshal((InputStream)wsXmlStream, (ObjectModelFactory)factory, null);
                }
                catch (JBossXBException e) {
                    throw new WSException("Could not unmarshal existing webservices descriptor: " + wsXmlFile, e);
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                ((InputStream)wsXmlStream).close();
                throw throwable;
            }
            ((InputStream)wsXmlStream).close();
            for (WebserviceDescriptionMetaData webserviceDescription : webservices.getWebserviceDescriptions()) {
                existingWebservices.addWebserviceDescription(webserviceDescription);
            }
            webservices = existingWebservices;
        }
        Element root = DOMUtils.parse(webservices.serialize());
        FileWriter fwriter = new FileWriter(wsXmlFile);
        new DOMWriter(fwriter).setPrettyprint(true).print(root);
        fwriter.close();
    }

    private WebservicesMetaData constructWSMetaData() {
        WebservicesMetaData wm = new WebservicesMetaData();
        WebserviceDescriptionMetaData wsdm = new WebserviceDescriptionMetaData(wm);
        this.populateWebserviceDescriptionMetaData(wsdm);
        wm.addWebserviceDescription(wsdm);
        return wm;
    }

    private void populateWebserviceDescriptionMetaData(WebserviceDescriptionMetaData wsdm) {
        this.checkEssentials();
        wsdm.setWebserviceDescriptionName(this.serviceName);
        wsdm.setWsdlFile(this.wsdlFile);
        wsdm.setJaxrpcMappingFile(this.mappingFile);
        PortComponentMetaData pm1 = new PortComponentMetaData(wsdm);
        pm1.setPortComponentName(this.portName);
        pm1.setWsdlPort(new QName(this.targetNamespace, this.portName, "portNS"));
        pm1.setServiceEndpointInterface(this.seiName);
        if (this.servletLink != null && this.servletLink.length() > 0) {
            pm1.setServletLink(this.servletLink);
        } else {
            pm1.setEjbLink(this.ejbLink);
        }
        wsdm.addPortComponent(pm1);
    }

    private void checkEssentials() {
        if (this.serviceName == null) {
            throw new WSException("serviceName is null");
        }
        if (this.wsdlFile == null) {
            throw new WSException("wsdlFile is null");
        }
        if (this.mappingFile == null) {
            throw new WSException("mappingFile is null");
        }
        if (this.targetNamespace == null) {
            throw new WSException("targetNamespace is null");
        }
        if (this.portName == null) {
            throw new WSException("portName is null");
        }
        if (this.seiName == null) {
            throw new WSException("seiName is null");
        }
        if (this.servletLink == null && this.ejbLink == null) {
            throw new WSException("Either servletLink or ejbLink should not be null");
        }
        if (this.servletLink != null && this.ejbLink != null) {
            throw new WSException("One of servletLink or ejbLink should be null");
        }
    }
}

