/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.event;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventEmitter;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.logging.Logger;
import org.jboss.util.CollectionsFactory;

public class AbstractEventEmitter
implements KernelEventEmitter {
    private static final Logger log = Logger.getLogger((Class)AbstractEventEmitter.class);
    protected static final Object NULL = new Object();
    protected Map eventListenerRegistry = CollectionsFactory.createConcurrentReaderMap();
    private long emitterSequence = 0L;

    public boolean hasListeners() {
        return !this.eventListenerRegistry.isEmpty();
    }

    public KernelEvent createEvent(String type, Object context) {
        return new AbstractEvent(this, type, this.nextEmitterSequence(), System.currentTimeMillis(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        Object filterObject = filter == null ? NULL : filter;
        Object handbackObject = handback == null ? NULL : handback;
        Map map = this.eventListenerRegistry;
        synchronized (map) {
            List listeners;
            Map handbacks = (Map)this.eventListenerRegistry.get(filterObject);
            if (handbacks == null) {
                handbacks = CollectionsFactory.createConcurrentReaderMap();
                this.eventListenerRegistry.put(filterObject, handbacks);
            }
            if ((listeners = (List)handbacks.get(handbackObject)) == null) {
                listeners = CollectionsFactory.createCopyOnWriteList();
                handbacks.put(handbackObject, listeners);
            }
            listeners.add(listener);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registered listener: " + listener + " with filter=" + filter + " handback=" + handback + " on object " + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        Object filterObject = filter == null ? NULL : filter;
        Object handbackObject = handback == null ? NULL : handback;
        Map map = this.eventListenerRegistry;
        synchronized (map) {
            List listeners;
            Map handbacks = (Map)this.eventListenerRegistry.get(filterObject);
            if (handbacks != null && (listeners = (List)handbacks.get(handbackObject)) != null && listeners.remove(listener)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Unregistered listener: " + listener + " with filter=" + filter + " handback=" + handback + " on object " + this));
                }
                return;
            }
        }
        throw new IllegalStateException("Listener not registered.");
    }

    public void fireKernelEvent(KernelEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Firing event: " + event + " on object " + this));
        }
        if (!this.eventListenerRegistry.isEmpty()) {
            Iterator i = this.eventListenerRegistry.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry registryEntry = i.next();
                KernelEventFilter filter = null;
                Object filterObject = registryEntry.getKey();
                if (filterObject != NULL) {
                    filter = (KernelEventFilter)filterObject;
                }
                Map handbacks = (Map)registryEntry.getValue();
                Iterator j = handbacks.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry handbackEntry = j.next();
                    Object handback = handbackEntry.getKey();
                    if (handback == NULL) {
                        handback = null;
                    }
                    List listeners = (List)handbackEntry.getValue();
                    ListIterator k = listeners.listIterator();
                    while (k.hasNext()) {
                        KernelEventListener listener = (KernelEventListener)k.next();
                        try {
                            if (filter != null && !filter.wantEvent(event, handback)) continue;
                            this.fireKernelEvent(listener, event, handback);
                        }
                        catch (Throwable t) {
                            log.debug((Object)"Ignored unhandled throwable: ", t);
                        }
                    }
                }
            }
        }
    }

    protected void fireKernelEvent(KernelEventListener listener, KernelEvent event, Object handback) {
        listener.onEvent(event, handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long nextEmitterSequence() {
        Map map = this.eventListenerRegistry;
        synchronized (map) {
            return this.emitterSequence++;
        }
    }
}

