/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.wsf.container.jboss42.EJBArchiveMetaDataAdapter;
import org.jboss.wsf.container.jboss42.EJBArchiveMetaDataAdapterEJB3;
import org.jboss.wsf.container.jboss42.JSEArchiveMetaDataAdapter;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class ContainerMetaDataAdapter {
    private static Logger log = Logger.getLogger(ContainerMetaDataAdapter.class);
    private EJBArchiveMetaDataAdapterEJB3 applicationMetaDataAdapterEJB3;
    private EJBArchiveMetaDataAdapter applicationMetaDataAdapterEJB21;
    private JSEArchiveMetaDataAdapter webMetaDataAdapter;

    public void setApplicationMetaDataAdapterEJB21(EJBArchiveMetaDataAdapter adapter) {
        this.applicationMetaDataAdapterEJB21 = adapter;
    }

    public void setApplicationMetaDataAdapterEJB3(EJBArchiveMetaDataAdapterEJB3 adapter) {
        this.applicationMetaDataAdapterEJB3 = adapter;
    }

    public void setWebMetaDataAdapter(JSEArchiveMetaDataAdapter adapter) {
        this.webMetaDataAdapter = adapter;
    }

    public void buildContainerMetaData(Deployment dep, DeploymentInfo di) {
        EJBArchiveMetaData appMetaData;
        dep.addAttachment(DeploymentInfo.class, (Object)di);
        dep.setProperty("org.jboss.ws.ejb3.deployed.object", (Object)di.deployedObject);
        if (di.metaData instanceof WebMetaData) {
            JSEArchiveMetaData webMetaData = this.webMetaDataAdapter.buildUnifiedWebMetaData(dep, di);
            if (webMetaData != null) {
                dep.addAttachment(JSEArchiveMetaData.class, (Object)webMetaData);
            }
            dep.setProperty("org.jboss.ws.webapp.url", (Object)this.getDeploymentURL(di));
        } else if (dep.getType() == Deployment.DeploymentType.JAXWS_EJB3) {
            EJBArchiveMetaData appMetaData2 = this.applicationMetaDataAdapterEJB3.buildUnifiedApplicationMetaData(dep);
            if (appMetaData2 != null) {
                dep.addAttachment(EJBArchiveMetaData.class, (Object)appMetaData2);
            }
        } else if (di.metaData instanceof ApplicationMetaData && (appMetaData = this.applicationMetaDataAdapterEJB21.buildUnifiedApplicationMetaData(dep, di)) != null) {
            dep.addAttachment(EJBArchiveMetaData.class, (Object)appMetaData);
        }
    }

    private URL getDeploymentURL(DeploymentInfo di) {
        String path;
        URL deploymentURL;
        URL uRL = deploymentURL = di.localUrl != null ? di.localUrl : di.url;
        if ("file".equals(deploymentURL.getProtocol()) && new File(path = deploymentURL.getPath()).isFile()) {
            try {
                deploymentURL = new URL("jar:file:" + path + "!/");
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return deploymentURL;
    }
}

