/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.oil2.OIL2Constants;
import org.jboss.mq.il.oil2.OIL2Request;
import org.jboss.mq.il.oil2.OIL2RequestListner;
import org.jboss.mq.il.oil2.OIL2Response;
import org.jboss.mq.il.oil2.OIL2SocketHandler;

public final class OIL2ServerIL
implements Serializable,
Cloneable,
ServerIL,
OIL2Constants {
    static final long serialVersionUID = 1841984837999477932L;
    private static final Logger log = Logger.getLogger(OIL2ServerIL.class);
    private static final String LOCAL_ADDR = "org.jboss.mq.il.oil2.localAddr";
    private static final String LOCAL_PORT = "org.jboss.mq.il.oil2.localPort";
    private String addr;
    private int port;
    private String socketFactoryName;
    private boolean enableTcpNoDelay = false;
    private transient InetAddress localAddr;
    private transient int localPort;
    private transient ObjectInputStream in;
    private transient ObjectOutputStream out;
    private transient Socket socket;
    OIL2SocketHandler socketHandler;

    public OIL2ServerIL(String addr, int port, String socketFactoryName, boolean enableTcpNoDelay) {
        this.addr = addr;
        this.port = port;
        this.socketFactoryName = socketFactoryName;
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public synchronized void connect() throws IOException {
        if (this.socket == null) {
            String tmp;
            boolean tracing = log.isTraceEnabled();
            if (tracing) {
                log.trace("Connecting to : " + this.addr + ":" + this.port);
            }
            SocketFactory socketFactory = null;
            if (this.socketFactoryName != null) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> factoryClass = loader.loadClass(this.socketFactoryName);
                    socketFactory = (SocketFactory)factoryClass.newInstance();
                }
                catch (Exception e) {
                    log.debug("Failed to load socket factory: " + this.socketFactoryName, e);
                }
            }
            if (socketFactory == null) {
                socketFactory = SocketFactory.getDefault();
            }
            if ((tmp = System.getProperty(LOCAL_ADDR)) != null) {
                this.localAddr = InetAddress.getByName(tmp);
            }
            if ((tmp = System.getProperty(LOCAL_PORT)) != null) {
                this.localPort = Integer.parseInt(tmp);
            }
            if (tracing) {
                log.trace("Connecting with addr=" + this.addr + ", port=" + this.port + ", localAddr=" + this.localAddr + ", localPort=" + this.localPort + ", socketFactory=" + socketFactory);
            }
            this.socket = this.localAddr != null ? socketFactory.createSocket(this.addr, this.port, this.localAddr, this.localPort) : socketFactory.createSocket(this.addr, this.port);
            if (tracing) {
                log.trace("Connection established.");
            }
            this.socket.setTcpNoDelay(this.enableTcpNoDelay);
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
            if (tracing) {
                log.trace("Streams initialized.");
            }
            this.socketHandler = new OIL2SocketHandler(this.in, this.out, Connection.getThreadGroup());
            this.socketHandler.setRequestListner(new RequestListner());
            this.socketHandler.start();
        }
    }

    public void setConnectionToken(ConnectionToken dest) throws Exception {
        this.connect();
        OIL2Request request = new OIL2Request(14, new Object[]{dest});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(13, new Object[]{new Boolean(enabled)});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public String getID() throws Exception {
        this.connect();
        OIL2Request request = new OIL2Request(9, null);
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (String)response.evalThrowsJMSException();
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(10, null);
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (TemporaryQueue)response.evalThrowsJMSException();
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(11, null);
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (TemporaryTopic)response.evalThrowsJMSException();
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(1, new Object[]{item});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public void addMessage(ConnectionToken dc, SpyMessage val) throws Exception {
        this.connect();
        OIL2Request request = new OIL2Request(2, new Object[]{val});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(3, new Object[]{dest, selector});
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (SpyMessage[])response.evalThrowsJMSException();
    }

    public void checkID(String ID2) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(4, new Object[]{ID2});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public String checkUser(String userName, String password) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(19, new Object[]{userName, password});
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (String)response.evalThrowsJMSException();
    }

    public String authenticate(String userName, String password) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(22, new Object[]{userName, password});
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (String)response.evalThrowsJMSException();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ServerIL cloneServerIL() throws Exception {
        return (ServerIL)this.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosing(ConnectionToken dc) throws JMSException, Exception {
        try {
            this.connect();
            OIL2Request request = new OIL2Request(5, null);
            OIL2Response response = this.socketHandler.synchRequest(request);
            response.evalThrowsJMSException();
            Object var5_4 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
    }

    public Queue createQueue(ConnectionToken dc, String dest) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(6, new Object[]{dest});
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (Queue)response.evalThrowsJMSException();
    }

    public Topic createTopic(ConnectionToken dc, String dest) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(7, new Object[]{dest});
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (Topic)response.evalThrowsJMSException();
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(8, new Object[]{dest});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(18, new Object[]{id});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public void ping(ConnectionToken dc, long clientTime) throws Exception {
        this.connect();
        OIL2Request request = new OIL2Request(20, new Object[]{new Long(clientTime)});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws Exception, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(12, new Object[]{new Integer(subscriberId), new Long(wait)});
        OIL2Response response = this.socketHandler.synchRequest(request);
        return (SpyMessage)response.evalThrowsJMSException();
    }

    public void subscribe(ConnectionToken dc, Subscription s) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(15, new Object[]{s});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(16, new Object[]{t});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException, Exception {
        this.connect();
        OIL2Request request = new OIL2Request(17, new Object[]{new Integer(subscriptionId)});
        OIL2Response response = this.socketHandler.synchRequest(request);
        response.evalThrowsJMSException();
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socketHandler.stop();
                this.in.close();
                this.out.close();
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e) {
            log.debug("Exception occured while closing opened resources: ", e);
        }
    }

    class RequestListner
    implements OIL2RequestListner {
        RequestListner() {
        }

        public void handleConnectionException(Exception e) {
        }

        public void handleRequest(OIL2Request request) {
        }
    }
}

