/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientDisconnectedException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;

public class ConnectionNotifier {
    private List listeners = Collections.synchronizedList(new ArrayList());
    private static final Logger log = Logger.getLogger(ConnectionNotifier.class);

    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void addListenerFirst(ConnectionListener listener) {
        this.listeners.add(0, listener);
    }

    public void removeListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public int size() {
        return this.listeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionLost(String locatorurl, String clientSessionId, Map requestPayload) {
        try {
            log.debug("Server connection lost to client (session id = " + clientSessionId);
            Client client = new Client(new InvokerLocator(locatorurl), requestPayload);
            client.setSessionId(clientSessionId);
            List list = this.listeners;
            synchronized (list) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    ((ConnectionListener)it.next()).handleConnectionException(null, client);
                }
            }
        }
        catch (Exception e) {
            log.error("Error notifying connection listeners of lost client connection.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionTerminated(String locatorURL, String clientSessionId, Map requestPayload) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Client disconnected (session id = " + clientSessionId);
            }
            Client client = new Client(new InvokerLocator(locatorURL), requestPayload);
            client.setSessionId(clientSessionId);
            ClientDisconnectedException ex = new ClientDisconnectedException();
            List list = this.listeners;
            synchronized (list) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    ((ConnectionListener)it.next()).handleConnectionException(ex, client);
                }
            }
        }
        catch (Exception e) {
            log.error("Error notifying connection listeners of disconnected client connection.", e);
        }
    }
}

