/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.remoting;

import java.io.Serializable;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.logging.Logger;
import org.jboss.serial.io.MarshalledObjectForLocalCalls;

public class IsLocalInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 337700910587744646L;
    private static final Logger log = Logger.getLogger(IsLocalInterceptor.class);
    public static final String GUID = "GUID";
    public static final String IS_LOCAL = "IS_LOCAL";
    public static final String IS_LOCAL_EXCEPTION = "IS_LOCAL_EXCEPTION";
    private static final long stamp = System.currentTimeMillis();
    private long marshalledStamp = stamp;

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isLocal()) {
            String guid = (String)invocation.getMetaData((Object)IS_LOCAL, (Object)GUID);
            Container container = Ejb3Registry.getContainer(guid);
            return this.invokeLocal(invocation, container);
        }
        return invocation.invokeNext();
    }

    protected Object invokeLocal(Invocation invocation, Container container) throws Throwable {
        MarshalledObjectForLocalCalls wrappedException;
        Invocation copy = (Invocation)new MarshalledObjectForLocalCalls((Object)invocation).get();
        copy.getMetaData().addMetaData((Object)IS_LOCAL, (Object)IS_LOCAL, (Object)Boolean.TRUE);
        InvocationResponse response = ((Advisor)container).dynamicInvoke(null, copy);
        Map contextInfo = response.getContextInfo();
        if (contextInfo != null && (wrappedException = (MarshalledObjectForLocalCalls)response.getContextInfo().get(IS_LOCAL_EXCEPTION)) != null) {
            throw (Throwable)wrappedException.get();
        }
        invocation.setResponseContextInfo(response.getContextInfo());
        MarshalledObjectForLocalCalls wrapped = (MarshalledObjectForLocalCalls)response.getResponse();
        Object rtn = null;
        if (wrapped != null) {
            rtn = wrapped.get();
        }
        return rtn;
    }

    protected boolean isLocal() {
        return stamp == this.marshalledStamp;
    }
}

