/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.Util;
import org.jboss.iiop.rmi.ValueAnalysis;
import org.jboss.iiop.rmi.WorkCacheManager;
import org.jboss.logging.Logger;

public class ExceptionAnalysis
extends ValueAnalysis {
    private static final Logger logger = Logger.getLogger(ExceptionAnalysis.class);
    private static WorkCacheManager cache = new WorkCacheManager(ExceptionAnalysis.class);
    private String exceptionRepositoryId;

    public static ExceptionAnalysis getExceptionAnalysis(Class cls) throws RMIIIOPViolationException {
        return (ExceptionAnalysis)cache.getAnalysis(cls);
    }

    protected ExceptionAnalysis(Class cls) {
        super(cls);
        logger.debug((Object)("ExceptionAnalysis(\"" + cls.getName() + "\") entered."));
    }

    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        if (!Exception.class.isAssignableFrom(this.cls) || RuntimeException.class.isAssignableFrom(this.cls)) {
            throw new RMIIIOPViolationException("Exception type " + this.cls.getName() + " must be a checked exception class.", "1.2.6");
        }
        StringBuffer b = new StringBuffer("IDL:");
        String pkgName = this.cls.getPackage().getName();
        while (!"".equals(pkgName)) {
            int idx = pkgName.indexOf(46);
            String n = idx == -1 ? pkgName : pkgName.substring(0, idx);
            b.append(Util.javaToIDLName(n)).append('/');
            pkgName = idx == -1 ? "" : pkgName.substring(idx + 1);
        }
        String base = this.cls.getName();
        if ((base = base.substring(base.lastIndexOf(46) + 1)).endsWith("Exception")) {
            base = base.substring(0, base.length() - 9);
        }
        base = Util.javaToIDLName(base + "Ex");
        b.append(base).append(":1.0");
        this.exceptionRepositoryId = b.toString();
    }

    public String getExceptionRepositoryId() {
        return this.exceptionRepositoryId;
    }
}

