/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeHierarchyCreatorImpl
implements NodeHierarchyCreator,
Startable {
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String USERS_PATH = "usersPath";
    private static final String USER_APPLICATION = "userApplicationData";
    private static final String PUBLIC_APPLICATION = "eXoApplications";
    private static final String USER_PRIVATE = "userPrivate";
    private static final String USER_PUBLIC = "userPublic";
    private RepositoryService jcrService_;
    List<AddPathPlugin> pathPlugins_ = new ArrayList<AddPathPlugin>();

    public NodeHierarchyCreatorImpl(RepositoryService jcrService) throws Exception {
        this.jcrService_ = jcrService;
    }

    public void start() {
        try {
            this.processAddPathPlugin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        this.initBasePath(repository);
    }

    private void createNode(Node rootNode, String path, String nodeType, List<String> mixinTypes, Map permissions) throws Exception {
        Node node = rootNode;
        for (String token : path.split("/")) {
            if (token.length() <= 0) continue;
            try {
                node = node.getNode(token);
            }
            catch (PathNotFoundException e) {
                if (nodeType == null || nodeType.length() == 0) {
                    nodeType = NT_UNSTRUCTURED;
                }
                if ((node = node.addNode(token, nodeType)).canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                if (permissions != null && !permissions.isEmpty()) {
                    ((ExtendedNode)node).setPermissions(permissions);
                }
                if (mixinTypes.size() <= 0) continue;
                for (String mixin : mixinTypes) {
                    if (!node.canAddMixin(mixin)) continue;
                    node.addMixin(mixin);
                }
            }
        }
    }

    public Map getPermissions(List<HierarchyConfig.Permission> permissions) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        for (HierarchyConfig.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }

    private void processAddPathPlugin() throws Exception {
        Session session = null;
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            String repository = hierarchyConfig.getRepository();
            List<HierarchyConfig.JcrPath> jcrPaths = hierarchyConfig.getJcrPaths();
            for (String workspaceName : hierarchyConfig.getWorkspaces()) {
                session = this.jcrService_.getRepository(repository).getSystemSession(workspaceName);
                Node rootNode = session.getRootNode();
                for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
                    List<String> mixinTypes;
                    String nodeType = jcrPath.getNodeType();
                    if (nodeType == null || nodeType.length() == 0) {
                        nodeType = NT_UNSTRUCTURED;
                    }
                    if ((mixinTypes = jcrPath.getMixinTypes()) == null) {
                        mixinTypes = new ArrayList<String>();
                    }
                    if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                    this.createNode(rootNode, jcrPath.getPath(), nodeType, mixinTypes, this.getPermissions(jcrPath.getPermissions()));
                }
                session.save();
                session.logout();
            }
        }
    }

    private void initBasePath(String repository) throws Exception {
        Session session = null;
        ManageableRepository manageableRepository = this.jcrService_.getRepository(repository);
        String defaultWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        String systemWorkspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        boolean isSameWorksapce = defaultWorkspace.equalsIgnoreCase(systemWorkspace);
        String[] workspaceNames = manageableRepository.getWorkspaceNames();
        for (AddPathPlugin pathPlugin : this.pathPlugins_) {
            HierarchyConfig hierarchyConfig = pathPlugin.getPaths();
            List<HierarchyConfig.JcrPath> jcrPaths = hierarchyConfig.getJcrPaths();
            for (String workspaceName : workspaceNames) {
                if (!isSameWorksapce && workspaceName.equalsIgnoreCase(systemWorkspace)) continue;
                session = manageableRepository.getSystemSession(workspaceName);
                Node rootNode = session.getRootNode();
                for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
                    List<String> mixinTypes;
                    String nodeType = jcrPath.getNodeType();
                    if (nodeType == null || nodeType.length() == 0) {
                        nodeType = NT_UNSTRUCTURED;
                    }
                    if ((mixinTypes = jcrPath.getMixinTypes()) == null) {
                        mixinTypes = new ArrayList<String>();
                    }
                    if (jcrPath.getAlias().equals(USER_APPLICATION) || jcrPath.getAlias().startsWith(USER_PRIVATE) || jcrPath.getAlias().startsWith(USER_PUBLIC)) continue;
                    this.createNode(rootNode, jcrPath.getPath(), nodeType, mixinTypes, this.getPermissions(jcrPath.getPermissions()));
                }
                session.save();
                session.logout();
            }
        }
    }

    @Override
    public Node getUserApplicationNode(SessionProvider sessionProvider, String userName) throws Exception {
        Node userNode = this.getUserNode(sessionProvider, userName);
        Node userAppNode = null;
        try {
            userAppNode = userNode.getNode(this.getJcrPath(USER_APPLICATION));
        }
        catch (PathNotFoundException e) {
            userAppNode = userNode.addNode(this.getJcrPath(USER_APPLICATION));
            userNode.save();
        }
        return userAppNode;
    }

    @Override
    public Node getPublicApplicationNode(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this.jcrService_.getCurrentRepository();
        Session session = this.getSession(sessionProvider, currentRepo, currentRepo.getConfiguration().getDefaultWorkspaceName());
        Node rootNode = session.getRootNode();
        String publicApplication = this.getJcrPath(PUBLIC_APPLICATION);
        session.logout();
        return rootNode.getNode(publicApplication.substring(1, publicApplication.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getUserNode(SessionProvider sessionProvider, String userName) throws Exception {
        String userPath = this.getJcrPath(USERS_PATH);
        ManageableRepository currentRepo = this.jcrService_.getCurrentRepository();
        Session session = this.getSession(sessionProvider, currentRepo, currentRepo.getConfiguration().getDefaultWorkspaceName());
        Node usersNode = (Node)session.getItem(userPath);
        Node userNode = null;
        try {
            userNode = usersNode.getNode(userName);
        }
        catch (PathNotFoundException e) {
            userNode = usersNode.addNode(userName);
            usersNode.save();
        }
        finally {
            session.logout();
        }
        return userNode;
    }

    private Session getSession(SessionProvider sessionProvider, ManageableRepository repo, String defaultWorkspace) throws RepositoryException {
        return sessionProvider.getSession(defaultWorkspace, repo);
    }

    @Override
    public String getJcrPath(String alias) {
        for (int j = 0; j < this.pathPlugins_.size(); ++j) {
            HierarchyConfig config = this.pathPlugins_.get(j).getPaths();
            List<HierarchyConfig.JcrPath> jcrPaths = config.getJcrPaths();
            for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
                if (!jcrPath.getAlias().equals(alias)) continue;
                return jcrPath.getPath();
            }
        }
        return null;
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddPathPlugin) {
            this.pathPlugins_.add((AddPathPlugin)plugin);
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return null;
    }
}

