/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.UriCallback;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.opensocial.UriCallbackOption;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.reporting.SnippetProducer;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;

public class CajaContentRewriter
implements GadgetRewriter {
    private final Logger logger = Logger.getLogger(CajaContentRewriter.class.getName());

    public void rewrite(Gadget gadget, MutableContent content) {
        if (gadget.getSpec().getModulePrefs().getFeatures().containsKey("caja") || "1".equals(gadget.getContext().getParameter("caja"))) {
            final URI retrievedUri = gadget.getContext().getUrl().toJavaUri();
            UriCallback cb = new UriCallback(){

                public UriCallbackOption getOption(ExternalReference externalReference, String string) {
                    return UriCallbackOption.REWRITE;
                }

                public Reader retrieve(ExternalReference externalReference, String string) throws UriCallbackException {
                    CajaContentRewriter.this.logger.info("Retrieving " + externalReference.toString());
                    try {
                        int n;
                        URI resourceUri = retrievedUri.resolve(externalReference.getUri());
                        InputStreamReader in = new InputStreamReader(resourceUri.toURL().openConnection().getInputStream(), "UTF-8");
                        char[] buf = new char[4096];
                        StringBuilder sb = new StringBuilder();
                        while ((n = in.read(buf)) > 0) {
                            sb.append(buf, 0, n);
                        }
                        return new StringReader(sb.toString());
                    }
                    catch (MalformedURLException ex) {
                        throw new UriCallbackException(externalReference, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        throw new UriCallbackException(externalReference, (Throwable)ex);
                    }
                }

                public URI rewrite(ExternalReference externalReference, String string) {
                    return retrievedUri.resolve(externalReference.getUri());
                }
            };
            SimpleMessageQueue mq = new SimpleMessageQueue();
            BuildInfo bi = BuildInfo.getInstance();
            DefaultGadgetRewriter rw = new DefaultGadgetRewriter(bi, (MessageQueue)mq);
            rw.setValijaMode(true);
            InputSource is = new InputSource(retrievedUri);
            String origContent = content.getContent();
            CharProducer input = CharProducer.Factory.create((StringReader)new StringReader(origContent), (FilePosition)FilePosition.instance((InputSource)is, (int)5, (int)5, (int)5));
            StringBuilder output = new StringBuilder();
            content.setContent("");
            try {
                rw.rewriteContent(retrievedUri, input, cb, (Appendable)output);
            }
            catch (GadgetRewriteException e) {
                content.setContent(this.messagesToHtml(is, origContent, (MessageQueue)mq));
                this.throwCajolingException((Exception)((Object)e), (MessageQueue)mq);
                return;
            }
            catch (IOException e) {
                content.setContent(this.messagesToHtml(is, origContent, (MessageQueue)mq));
                this.throwCajolingException(e, (MessageQueue)mq);
                return;
            }
            content.setContent(this.tameCajaClientApi() + output);
        }
    }

    private String messagesToHtml(InputSource is, CharSequence orig, MessageQueue mq) {
        MessageContext mc = new MessageContext();
        HashMap originalSrc = Maps.newHashMap();
        originalSrc.put(is, orig);
        mc.addInputSource(is);
        SnippetProducer sp = new SnippetProducer((Map)originalSrc, mc);
        StringBuilder messageText = new StringBuilder();
        messageText.append("<pre>");
        for (Message msg : mq.getMessages()) {
            if (MessageLevel.LINT.compareTo((Enum)msg.getMessageLevel()) > 0) continue;
            String snippet = sp.getSnippet(msg);
            messageText.append(msg.getMessageLevel().name()).append(" ").append(CajaContentRewriter.html(msg.format(mc)));
            if (StringUtils.isEmpty((String)snippet)) continue;
            messageText.append("\n").append(snippet);
        }
        messageText.append("</pre>");
        return messageText.toString();
    }

    private static String html(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        Escaping.escapeXml((CharSequence)s, (boolean)false, (StringBuilder)sb);
        return sb.toString();
    }

    private String tameCajaClientApi() {
        return "<script>opensocial.Container.get().enableCaja();</script>";
    }

    private void throwCajolingException(Exception cause, MessageQueue mq) {
        StringBuilder errbuilder = new StringBuilder();
        MessageContext mc = new MessageContext();
        if (cause != null) {
            errbuilder.append(cause).append('\n');
        }
        for (Message m : mq.getMessages()) {
            errbuilder.append(m.format(mc)).append('\n');
        }
        this.logger.info("Unable to cajole gadget: " + errbuilder);
    }
}

