/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.propfind.PropFindRequestEntity;
import org.exoplatform.services.jcr.webdav.command.propfind.PropFindResponseEntity;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionedCollectionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFindCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.PropFindCommand");

    public Response propfind(Session session, String path, HierarchicalProperty body, int depth, String baseURI) {
        PropFindResponseEntity response;
        GenericResource resource;
        Node node;
        try {
            node = (Node)session.getItem(path);
        }
        catch (PathNotFoundException e) {
            return Response.status((int)404).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
        try {
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            resource = null;
            URI uri = "/".equals(node.getPath()) ? new URI(TextUtil.escape(baseURI, '%', true)) : new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            resource = ResourceUtil.isVersioned(node) ? (ResourceUtil.isFile(node) ? new VersionedFileResource(uri, node, nsContext) : new VersionedCollectionResource(uri, node, nsContext)) : (ResourceUtil.isFile(node) ? new FileResource(uri, node, nsContext) : new CollectionResource(uri, node, nsContext));
        }
        catch (Exception e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
            return Response.serverError().build();
        }
        PropFindRequestEntity request = new PropFindRequestEntity(body);
        if (request.getType().equalsIgnoreCase("allprop")) {
            response = new PropFindResponseEntity(depth, resource, null, false);
        } else if (request.getType().equalsIgnoreCase("propname")) {
            response = new PropFindResponseEntity(depth, resource, null, true);
        } else if (request.getType().equalsIgnoreCase("prop")) {
            response = new PropFindResponseEntity(depth, resource, this.propertyNames(body), false);
        } else {
            return Response.status((int)400).entity((Object)"Bad Request").build();
        }
        return Response.status((int)207).entity((Object)response).header("Content-Type", (Object)"text/xml").build();
    }

    private Set<QName> propertyNames(HierarchicalProperty body) {
        HashSet<QName> names = new HashSet<QName>();
        HierarchicalProperty propBody = body.getChild(0);
        List properties = propBody.getChildren();
        for (HierarchicalProperty property : properties) {
            names.add(property.getName());
        }
        return names;
    }
}

