/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class OEPlaceholderAtom
extends RecordAtom {
    public static final int PLACEHOLDER_FULLSIZE = 0;
    public static final int PLACEHOLDER_HALFSIZE = 1;
    public static final int PLACEHOLDER_QUARTSIZE = 2;
    public static final byte None = 0;
    public static final byte MasterTitle = 1;
    public static final byte MasterBody = 2;
    public static final byte MasterCenteredTitle = 3;
    public static final byte MasterNotesSlideImage = 4;
    public static final byte MasterNotesBodyImage = 5;
    public static final byte MasterDate = 6;
    public static final byte MasterSlideNumber = 7;
    public static final byte MasterFooter = 8;
    public static final byte MasterHeader = 9;
    public static final byte MasterSubtitle = 10;
    public static final byte GenericTextObject = 11;
    public static final byte Title = 12;
    public static final byte Body = 13;
    public static final byte NotesBody = 14;
    public static final byte CenteredTitle = 15;
    public static final byte Subtitle = 16;
    public static final byte VerticalTextTitle = 17;
    public static final byte VerticalTextBody = 18;
    public static final byte NotesSlideImage = 19;
    public static final byte Object = 20;
    public static final byte Graph = 21;
    public static final byte Table = 22;
    public static final byte ClipArt = 23;
    public static final byte OrganizationChart = 24;
    public static final byte MediaClip = 25;
    private byte[] _header = new byte[8];
    private int placementId;
    private int placeholderId;
    private int placeholderSize;

    public OEPlaceholderAtom() {
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)8);
        this.placementId = 0;
        this.placeholderId = 0;
        this.placeholderSize = 0;
    }

    protected OEPlaceholderAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this.placementId = LittleEndian.getInt((byte[])source, (int)start);
        this.placeholderId = LittleEndian.getUnsignedByte((byte[])source, (int)(start + 4));
        this.placeholderSize = LittleEndian.getUnsignedByte((byte[])source, (int)(start + 5));
    }

    public long getRecordType() {
        return RecordTypes.OEPlaceholderAtom.typeID;
    }

    public int getPlacementId() {
        return this.placementId;
    }

    public void setPlacementId(int id) {
        this.placementId = id;
    }

    public int getPlaceholderId() {
        return this.placeholderId;
    }

    public void setPlaceholderId(byte id) {
        this.placeholderId = id;
    }

    public int getPlaceholderSize() {
        return this.placeholderSize;
    }

    public void setPlaceholderSize(byte size) {
        this.placeholderSize = size;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        byte[] recdata = new byte[8];
        LittleEndian.putInt((byte[])recdata, (int)0, (int)this.placementId);
        recdata[4] = (byte)this.placeholderId;
        recdata[5] = (byte)this.placeholderSize;
        out.write(recdata);
    }
}

