/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import org.reflext.api.TypeInfo;
import org.reflext.core.ArrayTypeInfoImpl;
import org.reflext.core.ClassTypeInfoImpl;
import org.reflext.core.ParameterizedTypeInfoImpl;
import org.reflext.core.SimpleTypeInfoImpl;
import org.reflext.core.TypeInfoImpl;
import org.reflext.core.TypeVariableInfoImpl;
import org.reflext.core.VoidTypeInfoImpl;
import org.reflext.core.WildcardTypeInfoImpl;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.TypeKind;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDomain<T, M> {
    final TypeModel<T> typeModel;
    final MethodModel<T, M> methodModel;

    public TypeDomain(TypeModel<T> typeModel, MethodModel<T, M> methodModel) {
        this.typeModel = typeModel;
        this.methodModel = methodModel;
    }

    public TypeInfo getType(T type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        return this._getType(type);
    }

    TypeInfoImpl<T, M> _getType(T type) {
        TypeKind kind = this.typeModel.getKind(type);
        switch (kind) {
            case SIMPLE: {
                return new SimpleTypeInfoImpl(this, type);
            }
            case VOID: {
                return new VoidTypeInfoImpl(this, type);
            }
            case CLASS: {
                return new ClassTypeInfoImpl(this, type);
            }
            case PARAMETERIZED: {
                return new ParameterizedTypeInfoImpl(this, type);
            }
            case VARIABLE: {
                return new TypeVariableInfoImpl(this, type);
            }
            case WILDCARD: {
                return new WildcardTypeInfoImpl(this, type);
            }
            case ARRAY: {
                return new ArrayTypeInfoImpl(this, type);
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + type + " with kind " + kind));
    }
}

