/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.monitor.jvm.JVMRuntimeInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.picocontainer.Startable;

public class JVMRuntimeInfoImpl
implements JVMRuntimeInfo,
Startable {
    private RuntimeMXBean mxbean_ = ManagementFactory.getRuntimeMXBean();

    public JVMRuntimeInfoImpl(InitParams params) throws Exception {
        PropertiesParam param = params.getPropertiesParam("add.system.properties");
        if (param != null) {
            ExoProperties props = param.getProperties();
            for (Map.Entry entry : props.entrySet()) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getName() {
        return this.mxbean_.getName();
    }

    public String getSpecName() {
        return this.mxbean_.getSpecName();
    }

    public String getSpecVendor() {
        return this.mxbean_.getSpecVendor();
    }

    public String getSpecVersion() {
        return this.mxbean_.getSpecVersion();
    }

    public String getManagementSpecVersion() {
        return this.mxbean_.getManagementSpecVersion();
    }

    public String getVmName() {
        return this.mxbean_.getVmName();
    }

    public String getVmVendor() {
        return this.mxbean_.getVmVendor();
    }

    public String getVmVersion() {
        return this.mxbean_.getVmVersion();
    }

    public List getInputArguments() {
        return this.mxbean_.getInputArguments();
    }

    public Map getSystemProperties() {
        return this.mxbean_.getSystemProperties();
    }

    public boolean getBootClassPathSupported() {
        return this.mxbean_.isBootClassPathSupported();
    }

    public String getBootClassPath() {
        return this.mxbean_.getBootClassPath();
    }

    public String getClassPath() {
        return this.mxbean_.getClassPath();
    }

    public String getLibraryPath() {
        return this.mxbean_.getLibraryPath();
    }

    public long getStartTime() {
        return this.mxbean_.getStartTime();
    }

    public long getUptime() {
        return this.mxbean_.getUptime();
    }

    public boolean isManagementSupported() {
        return true;
    }

    public String getSystemPropertiesAsText() {
        StringBuffer b = new StringBuffer();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            b.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return b.toString();
    }

    public void start() {
    }

    public void stop() {
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Name: ").append(this.getName()).append("\n");
        b.append("Specification Name: ").append(this.getSpecName()).append("\n");
        b.append("Specification Vendor: ").append(this.getSpecVendor()).append("\n");
        b.append("Specification Version: ").append(this.getSpecVersion()).append("\n");
        b.append("Management Spec Version: ").append(this.getManagementSpecVersion()).append("\n\n");
        b.append("Virtual Machine Name: ").append(this.getVmName()).append("\n");
        b.append("Virtual Machine Vendor: ").append(this.getVmVendor()).append("\n");
        b.append("Virtual Machine Version: ").append(this.getVmVersion()).append("\n\n");
        b.append("Input Arguments: ").append(this.getInputArguments()).append("\n");
        b.append("System Properties: ").append(this.getSystemProperties()).append("\n\n");
        b.append("Boot Class Path Support: ").append(this.getBootClassPathSupported()).append("\n");
        b.append("Boot Class Path: ").append(this.getBootClassPath()).append("\n");
        b.append("Class Path: ").append(this.getClassPath()).append("\n");
        b.append("Library Path: ").append(this.getLibraryPath()).append("\n\n");
        b.append("Start Time: ").append(new Date(this.getStartTime())).append("\n");
        b.append("Up Time: ").append(this.getUptime() / 60000L).append("min\n");
        return b.toString();
    }
}

