/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.upload.MimeTypeUploadPlugin;
import org.exoplatform.upload.RequestStreamReader;
import org.exoplatform.upload.UploadResource;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadService {
    private static final Logger log = LoggerFactory.getLogger(UploadService.class);
    private List<MimeTypeUploadPlugin> plugins;
    private Map<String, UploadResource> uploadResources = new LinkedHashMap<String, UploadResource>();
    private String uploadLocation_;
    private int defaultUploadLimitMB_;
    private Map<String, Integer> uploadLimitsMB_ = new LinkedHashMap<String, Integer>();
    public static String UPLOAD_RESOURCES_STACK = "uploadResourcesStack";

    public UploadService(PortalContainerInfo pinfo, InitParams params) throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.defaultUploadLimitMB_ = params == null || params.getValueParam("upload.limit.size") == null ? 0 : Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
        this.uploadLocation_ = tmpDir + "/" + pinfo.getContainerName() + "/eXoUpload";
        File uploadDir = new File(this.uploadLocation_);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
    }

    public void register(MimeTypeUploadPlugin plugin) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<MimeTypeUploadPlugin>();
        }
        this.plugins.add(plugin);
    }

    public void createUploadResource(HttpServletRequest request) throws FileUploadException {
        String uploadId = request.getParameter("uploadId");
        this.createUploadResource(uploadId, request);
    }

    public void createUploadResource(String uploadId, HttpServletRequest request) throws FileUploadException {
        UploadResource upResource = new UploadResource(uploadId);
        upResource.setFileName("");
        this.uploadResources.put(upResource.getUploadId(), upResource);
        this.putToStackInSession(request.getSession(true), uploadId);
        double contentLength = request.getContentLength();
        upResource.setEstimatedSize(contentLength);
        if (this.isLimited(upResource, contentLength)) {
            upResource.setStatus(2);
            return;
        }
        ServletFileUpload servletFileUpload = this.makeServletFileUpload(upResource);
        List itemList = servletFileUpload.parseRequest(request);
        if (itemList == null || itemList.size() != 1 || ((FileItem)itemList.get(0)).isFormField()) {
            log.debug((Object)"Please upload 1 file per request");
            return;
        }
        DiskFileItem fileItem = (DiskFileItem)itemList.get(0);
        String fileName = fileItem.getName();
        if (fileName == null) {
            fileName = uploadId;
        }
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        String storeLocation = this.uploadLocation_ + "/" + uploadId + "." + fileName;
        fileItem.getStoreLocation().renameTo(new File(storeLocation));
        upResource.setFileName(fileName);
        upResource.setMimeType(fileItem.getContentType());
        if (this.plugins != null) {
            for (MimeTypeUploadPlugin plugin : this.plugins) {
                String mimeType = plugin.getMimeType(fileName);
                if (mimeType == null) continue;
                upResource.setMimeType(mimeType);
            }
        }
        upResource.setStoreLocation(storeLocation);
        upResource.setStatus(1);
    }

    public void createUploadResource(String uploadId, String encoding, String contentType, double contentLength, InputStream inputStream) throws Exception {
        UploadResource upResource = new UploadResource(uploadId);
        RequestStreamReader reader = new RequestStreamReader(upResource);
        this.uploadResources.put(upResource.getUploadId(), upResource);
        if (this.isLimited(upResource, contentLength)) {
            upResource.setStatus(2);
            return;
        }
        Map<String, String> headers = reader.parseHeaders(inputStream, encoding);
        String fileName = reader.getFileName(headers);
        if (fileName == null) {
            fileName = uploadId;
        }
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        upResource.setFileName(fileName);
        upResource.setMimeType(headers.get("content-type"));
        upResource.setStoreLocation(this.uploadLocation_ + "/" + uploadId + "." + fileName);
        upResource.setEstimatedSize(contentLength);
        File fileStore = new File(upResource.getStoreLocation());
        if (!fileStore.exists()) {
            fileStore.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(fileStore);
        reader.readBodyData(inputStream, contentType, output);
        if (upResource.getStatus() == 0) {
            upResource.setStatus(1);
            return;
        }
        this.uploadResources.remove(uploadId);
        fileStore.delete();
    }

    private void putToStackInSession(HttpSession session, String uploadId) {
        HashSet<String> uploadResouceIds = (HashSet<String>)session.getAttribute(UPLOAD_RESOURCES_STACK);
        if (uploadResouceIds == null) {
            uploadResouceIds = new HashSet<String>();
        }
        uploadResouceIds.add(uploadId);
        session.setAttribute(UPLOAD_RESOURCES_STACK, uploadResouceIds);
    }

    public UploadResource getUploadResource(String uploadId) {
        return this.uploadResources.get(uploadId);
    }

    public void cleanUp(HttpSession session) {
        log.debug((Object)"Cleaning up uploaded files for temporariness");
        Set uploadIds = (Set)session.getAttribute(UPLOAD_RESOURCES_STACK);
        if (uploadIds != null) {
            for (String id : uploadIds) {
                this.removeUploadResource(id);
                this.uploadLimitsMB_.remove(id);
            }
        }
    }

    @Deprecated
    public void removeUpload(String uploadId) {
        this.removeUploadResource(uploadId);
    }

    public void removeUploadResource(String uploadId) {
        if (uploadId == null) {
            return;
        }
        UploadResource upResource = this.uploadResources.get(uploadId);
        if (upResource != null) {
            this.uploadResources.remove(uploadId);
            if (upResource.getStoreLocation() != null) {
                File file = new File(upResource.getStoreLocation());
                file.delete();
            }
        }
    }

    public void addUploadLimit(String uploadId, Integer limitMB) {
        if (limitMB == null) {
            this.uploadLimitsMB_.put(uploadId, this.defaultUploadLimitMB_);
        } else {
            this.uploadLimitsMB_.put(uploadId, limitMB);
        }
    }

    public Map<String, Integer> getUploadLimitsMB() {
        return this.uploadLimitsMB_;
    }

    private ServletFileUpload makeServletFileUpload(final UploadResource upResource) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0);
        factory.setRepository(new File(this.uploadLocation_));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        ProgressListener listener = new ProgressListener(){

            public void update(long pBytesRead, long pContentLength, int pItems) {
                if ((double)pBytesRead == upResource.getUploadedSize()) {
                    return;
                }
                upResource.addUploadedBytes((double)pBytesRead - upResource.getUploadedSize());
            }
        };
        upload.setProgressListener(listener);
        return upload;
    }

    private boolean isLimited(UploadResource upResource, double contentLength) {
        int limitMB = this.defaultUploadLimitMB_;
        if (this.uploadLimitsMB_.containsKey(upResource.getUploadId())) {
            limitMB = this.uploadLimitsMB_.get(upResource.getUploadId());
        }
        double estimatedSizeMB = contentLength / 1024.0 / 1024.0;
        if (limitMB > 0 && estimatedSizeMB > (double)limitMB) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Upload cancelled because file bigger than size limit : " + estimatedSizeMB + " MB > " + limitMB + " MB"));
            }
            return true;
        }
        return false;
    }
}

