/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.LinkType;
import org.xwiki.rendering.parser.LinkParser;
import org.xwiki.rendering.wiki.WikiModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkParser
implements LinkParser {
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("[a-zA-Z0-9+.-]*://");
    private static final String[] ESCAPES_REFERENCE = new String[]{"\\?", "\\@", "\\#"};
    private static final String[] ESCAPES_EXTRA = new String[]{"\\?", "\\@", "\\#", "\\\\"};
    private static final String[] ESCAPE_REPLACEMENTS_REFERENCE = new String[]{"?", "@", "#"};
    private static final String[] ESCAPE_REPLACEMENTS_EXTRA = new String[]{"?", "@", "#", "\\"};
    @Requirement
    private ComponentManager componentManager;

    protected abstract List<String> getAllowedURIPrefixes();

    @Override
    public Link parse(String rawLink) {
        StringBuffer content = new StringBuffer(rawLink);
        Link link = new Link();
        if (!this.isInWikiMode()) {
            link.setType(LinkType.URI);
            link.setReference(rawLink);
            return link;
        }
        link.setType(LinkType.DOCUMENT);
        String uri = this.parseURI(content);
        if (uri != null) {
            link.setReference(uri);
            link.setType(LinkType.URI);
        } else {
            String interwikiAlias = this.parseElementAfterString(content, "@");
            if (interwikiAlias != null) {
                link.setInterWikiAlias(this.removeEscapesFromExtraParts(interwikiAlias));
                link.setType(LinkType.INTERWIKI);
            }
            link.setQueryString(this.removeEscapesFromExtraParts(this.parseElementAfterString(content, "?")));
            link.setAnchor(this.removeEscapesFromExtraParts(this.parseElementAfterString(content, "#")));
            link.setReference(this.removeEscapesFromReferencePart(content.toString()));
        }
        return link;
    }

    protected String parseURI(StringBuffer content) {
        String uri = null;
        int uriSchemeDelimiter = content.indexOf(":");
        if (uriSchemeDelimiter > -1 && this.getAllowedURIPrefixes().contains(content.substring(0, uriSchemeDelimiter))) {
            uri = content.toString();
            content.setLength(0);
        } else {
            Matcher matcher = URL_SCHEME_PATTERN.matcher(content.toString());
            if (matcher.lookingAt()) {
                uri = content.toString();
                content.setLength(0);
            }
        }
        return uri;
    }

    protected String parseElementAfterString(StringBuffer content, String separator) {
        String element = null;
        int index = content.lastIndexOf(separator);
        if (index != -1 && !this.shouldEscape(content, index)) {
            element = content.substring(index + separator.length()).trim();
            content.delete(index, content.length());
        }
        return element;
    }

    private boolean isInWikiMode() {
        boolean result = true;
        try {
            this.componentManager.lookup(WikiModel.class);
        }
        catch (ComponentLookupException e) {
            result = false;
        }
        return result;
    }

    private String removeEscapesFromReferencePart(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_REFERENCE, (String[])ESCAPE_REPLACEMENTS_REFERENCE);
    }

    private String removeEscapesFromExtraParts(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_EXTRA, (String[])ESCAPE_REPLACEMENTS_EXTRA);
    }

    private boolean shouldEscape(StringBuffer content, int charPosition) {
        int counter = 0;
        for (int pos = charPosition - 1; pos > -1 && content.charAt(pos) == '\\'; --pos) {
            ++counter;
        }
        return counter % 2 != 0;
    }
}

