/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
public class DefaultTransformationManager
implements TransformationManager,
Initializable {
    @Requirement(role=Transformation.class)
    private List<Transformation> transformations = new ArrayList<Transformation>();

    public void initialize() throws InitializationException {
        Collections.sort(this.transformations);
    }

    public void performTransformations(XDOM dom, Syntax syntax) throws TransformationException {
        this.performTransformations((Block)dom, new TransformationContext(dom, syntax));
    }

    public void performTransformations(Block block, TransformationContext context) throws TransformationException {
        for (Transformation transformation : this.transformations) {
            transformation.transform(block, context);
        }
    }
}

