/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.logging.Logger;
import org.xwiki.component.logging.VoidLogger;
import org.xwiki.component.manager.ComponentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAnnotationLoader
extends AbstractLogEnabled {
    private static final String COMPONENT_LIST = "META-INF/components.txt";
    private static final String COMPONENT_OVERRIDE_LIST = "META-INF/component-overrides.txt";
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();

    public ComponentAnnotationLoader() {
        this.enableLogging((Logger)new VoidLogger());
    }

    public void initialize(ComponentManager manager, ClassLoader classLoader) {
        try {
            List<String> componentClassNames = this.getDeclaredComponents(classLoader, COMPONENT_LIST);
            List<String> componentOverrideClassNames = this.getDeclaredComponents(classLoader, COMPONENT_OVERRIDE_LIST);
            HashMap descriptorMap = new HashMap();
            for (String componentClassName : componentClassNames) {
                Class<?> componentClass = classLoader.loadClass(componentClassName);
                for (Class<?> componentRoleClass : this.findComponentRoleClasses(componentClass)) {
                    for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(componentClass, componentRoleClass)) {
                        RoleHint roleHint = new RoleHint(componentRoleClass, descriptor.getRoleHint());
                        if (descriptorMap.containsKey(roleHint)) {
                            ComponentDescriptor existingDescriptor = (ComponentDescriptor)descriptorMap.get(roleHint);
                            if (componentOverrideClassNames.contains(existingDescriptor.getImplementation().getName())) continue;
                            descriptorMap.put(new RoleHint(componentRoleClass, descriptor.getRoleHint()), descriptor);
                            if (componentOverrideClassNames.contains(descriptor.getImplementation().getName())) continue;
                            this.getLogger().warn("Component [" + existingDescriptor.getImplementation().getName() + "] is being overwritten by component [" + descriptor.getImplementation().getName() + "] for Role/Hint [" + roleHint + "]. It will not be possible to look it up.");
                            continue;
                        }
                        descriptorMap.put(new RoleHint(componentRoleClass, descriptor.getRoleHint()), descriptor);
                    }
                }
            }
            for (ComponentDescriptor descriptor : descriptorMap.values()) {
                manager.registerComponent(descriptor);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dynamically load components with annotations", e);
        }
    }

    public Set<Class<?>> findComponentRoleClasses(Class<?> componentClass) {
        LinkedHashSet classes = new LinkedHashSet();
        Component component = componentClass.getAnnotation(Component.class);
        if (component != null && component.roles().length > 0) {
            classes.addAll(Arrays.asList(component.roles()));
        } else {
            for (Class<?> interfaceClass : componentClass.getInterfaces()) {
                classes.addAll(this.findComponentRoleClasses(interfaceClass));
                for (Annotation annotation : interfaceClass.getDeclaredAnnotations()) {
                    if (!annotation.annotationType().getName().equals(ComponentRole.class.getName())) continue;
                    classes.add(interfaceClass);
                }
            }
            Class<?> superClass = componentClass.getSuperclass();
            if (superClass != null && !superClass.getName().equals(Object.class.getName())) {
                classes.addAll(this.findComponentRoleClasses(superClass));
            }
        }
        return classes;
    }

    private List<String> getDeclaredComponents(ClassLoader classLoader, String location) throws IOException {
        ArrayList<String> annotatedClassNames = new ArrayList<String>();
        Enumeration<URL> urls = classLoader.getResources(location);
        while (urls.hasMoreElements()) {
            String inputLine;
            URL url = urls.nextElement();
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.trim().length() <= 0) continue;
                annotatedClassNames.add(inputLine);
            }
            in.close();
        }
        return annotatedClassNames;
    }
}

