/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.BeanManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.properties.PropertyException;
import org.xwiki.properties.PropertyMandatoryException;
import org.xwiki.properties.RawProperties;
import org.xwiki.properties.internal.DefaultBeanDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultBeanManager
extends AbstractLogEnabled
implements BeanManager,
Initializable {
    private Map<Class<?>, BeanDescriptor> beanDescriptorCache = Collections.synchronizedMap(new HashMap());
    @Requirement
    private ConverterManager converterManager;
    private ValidatorFactory validatorFactory;

    public void initialize() throws InitializationException {
        try {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
        catch (ValidationException e) {
            this.getLogger().warn("Unable to find default JSR 303 provider. There will be no Java bean validation.");
        }
    }

    @Override
    public void populate(Object bean, Map<String, ?> values) throws PropertyException {
        HashMap<String, Object> remainingValues = new HashMap<String, Object>(values);
        this.populateBean(bean, remainingValues);
        if (!remainingValues.isEmpty() && bean instanceof RawProperties) {
            RawProperties rawProperties = (RawProperties)bean;
            for (Map.Entry entry : remainingValues.entrySet()) {
                rawProperties.set((String)entry.getKey(), entry.getValue());
            }
        }
        this.validateBean(bean);
    }

    private void populateBean(Object bean, Map<String, Object> values) throws PropertyException {
        BeanDescriptor beanDescriptor = this.getBeanDescriptor(bean.getClass());
        HashMap<String, String> lowerKeyMap = new HashMap<String, String>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            lowerKeyMap.put(entry.getKey().toLowerCase(), entry.getKey());
        }
        for (PropertyDescriptor propertyDescriptor : beanDescriptor.getProperties()) {
            String propertyId = propertyDescriptor.getId();
            Object value = values.get(propertyId);
            if (value == null) {
                propertyId = propertyId.toLowerCase();
                value = values.get(lowerKeyMap.get(propertyId));
            }
            if (value != null) {
                try {
                    Object convertedValue = this.converterManager.convert(propertyDescriptor.getPropertyClass(), value);
                    if (propertyDescriptor.getWriteMethod() != null) {
                        propertyDescriptor.getWriteMethod().invoke(bean, convertedValue);
                    } else if (propertyDescriptor.getFied() != null) {
                        propertyDescriptor.getFied().set(bean, convertedValue);
                    }
                }
                catch (Exception e) {
                    throw new PropertyException("Failed to populate property [" + propertyId + "]", e);
                }
                values.remove(propertyId);
                continue;
            }
            if (!propertyDescriptor.isMandatory()) continue;
            throw new PropertyMandatoryException(propertyId);
        }
    }

    private void validateBean(Object bean) throws PropertyException {
        Validator validator;
        Set constraintViolations;
        if (this.validatorFactory != null && !(constraintViolations = (validator = this.validatorFactory.getValidator()).validate(bean, new Class[0])).isEmpty()) {
            throw new PropertyException("Failed to validate bean: [" + ((ConstraintViolation)constraintViolations.iterator().next()).getMessage() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanDescriptor getBeanDescriptor(Class<?> beanClass) {
        BeanDescriptor beanDescriptor = null;
        if (beanClass != null) {
            Class<?> clazz = beanClass;
            synchronized (clazz) {
                beanDescriptor = this.beanDescriptorCache.get(beanClass);
                if (beanDescriptor == null) {
                    beanDescriptor = new DefaultBeanDescriptor(beanClass);
                    this.beanDescriptorCache.put(beanClass, beanDescriptor);
                }
            }
        }
        return beanDescriptor;
    }
}

