/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.util.HashMap;
import org.wikimodel.wem.IWikiParser;
import org.wikimodel.wem.xhtml.XhtmlParser;
import org.wikimodel.wem.xhtml.handler.CommentHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.rendering.internal.parser.wikimodel.AbstractWikiModelParser;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiCommentHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiDivisionTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiImageTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiReferenceTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiSpanTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.xhtml.XWikiTableDataTagHandler;
import org.xwiki.rendering.parser.ImageParser;
import org.xwiki.rendering.parser.LinkParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.xml.XMLReaderFactory;

@Component(value="xhtml/1.0")
public class WikiModelXHTMLParser
extends AbstractWikiModelParser {
    @Requirement(value="xwiki/2.0")
    private StreamParser xwikiParser;
    @Requirement(value="xwiki/2.0")
    private LinkParser linkParser;
    @Requirement(value="xwiki/2.0")
    private ImageParser imageParser;
    @Requirement(value="xwiki/2.0")
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;
    @Requirement(value="xwiki")
    private XMLReaderFactory xmlReaderFactory;

    public Syntax getSyntax() {
        return Syntax.XHTML_1_0;
    }

    public StreamParser getLinkLabelParser() {
        return this.xwikiParser;
    }

    public IWikiParser createWikiModelParser() throws ParseException {
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", (Object)handler);
        handlers.put("h2", (Object)handler);
        handlers.put("h3", (Object)handler);
        handlers.put("h4", (Object)handler);
        handlers.put("h5", (Object)handler);
        handlers.put("h6", (Object)handler);
        handlers.put("a", (Object)new XWikiReferenceTagHandler(this, this.linkParser, this.imageParser, this.xwikiSyntaxPrintRendererFactory, this.plainRendererFactory));
        handlers.put("img", (Object)new XWikiImageTagHandler());
        handlers.put("span", (Object)new XWikiSpanTagHandler());
        handlers.put("div", (Object)new XWikiDivisionTagHandler());
        handlers.put("th", (Object)new XWikiTableDataTagHandler());
        XhtmlParser parser = new XhtmlParser();
        parser.setExtraHandlers(handlers);
        parser.setCommentHandler((CommentHandler)new XWikiCommentHandler(this, this.linkParser, this.imageParser, this.xwikiSyntaxPrintRendererFactory, this.plainRendererFactory));
        try {
            parser.setXmlReader(this.xmlReaderFactory.createXMLReader());
        }
        catch (Exception e) {
            throw new ParseException("Failed to create XML reader", (Throwable)e);
        }
        return parser;
    }

    public ImageParser getImageParser() {
        return this.imageParser;
    }

    public LinkParser getLinkParser() {
        return this.linkParser;
    }
}

