/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel.xhtml;

import java.util.Stack;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.xhtml.handler.CommentHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.listener.Image;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ImageParser;
import org.xwiki.rendering.parser.LinkParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.xml.XMLUtils;

public class XWikiCommentHandler
extends CommentHandler {
    private StreamParser parser;
    private LinkParser linkParser;
    private ImageParser imageParser;
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;
    private PrintRendererFactory plainRendererFactory;
    private Stack<String> commentContentStack = new Stack();

    public XWikiCommentHandler(StreamParser parser, LinkParser linkParser, ImageParser imageParser, PrintRendererFactory xwikiSyntaxPrintRendererFactory, PrintRendererFactory plainRendererFactory) {
        this.parser = parser;
        this.linkParser = linkParser;
        this.xwikiSyntaxPrintRendererFactory = xwikiSyntaxPrintRendererFactory;
        this.imageParser = imageParser;
        this.plainRendererFactory = plainRendererFactory;
    }

    public void onComment(String content, XhtmlHandler.TagStack stack) {
        boolean ignoreElements = (Boolean)stack.getStackParameter("ignoreElements");
        if (!ignoreElements && content.startsWith("startwikilink:")) {
            this.handleLinkCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopwikilink")) {
            this.handleLinkCommentStop(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("startimage:")) {
            this.handleImageCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopimage")) {
            this.handleImageCommentStop(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("startmacro")) {
            super.onComment(XMLUtils.unescapeXMLComment((String)content), stack);
        } else {
            super.onComment(content, stack);
        }
    }

    private void handleLinkCommentStart(String content, XhtmlHandler.TagStack stack) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        PrintRenderer linkLabelRenderer = this.xwikiSyntaxPrintRendererFactory.createRenderer((WikiPrinter)printer);
        linkLabelRenderer.beginDocument(Listener.EMPTY_PARAMETERS);
        XWikiGeneratorListener xwikiListener = new XWikiGeneratorListener(this.parser, (Listener)linkLabelRenderer, this.linkParser, this.imageParser, this.plainRendererFactory, null);
        stack.pushStackParameter("linkListener", (Object)xwikiListener);
        stack.pushStackParameter("isInLink", (Object)true);
        stack.pushStackParameter("isFreeStandingLink", (Object)false);
        stack.pushStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
        this.commentContentStack.push(content.substring("startwikilink:".length()));
    }

    private void handleLinkCommentStop(String content, XhtmlHandler.TagStack stack) {
        XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)stack.popStackParameter("linkListener");
        PrintRenderer linkLabelRenderer = (PrintRenderer)xwikiListener.getListener();
        linkLabelRenderer.endDocument(Listener.EMPTY_PARAMETERS);
        boolean isFreeStandingLink = (Boolean)stack.getStackParameter("isFreeStandingLink");
        String linkComment = this.commentContentStack.pop();
        if (isFreeStandingLink) {
            stack.getScannerContext().onReference(linkComment);
        } else {
            String label = linkLabelRenderer.getPrinter().toString();
            String reference = linkComment;
            WikiParameters params = (WikiParameters)stack.getStackParameter("linkParameters");
            WikiReference wikiReference = new WikiReference(reference, label, params);
            stack.getScannerContext().onReference(wikiReference);
        }
        stack.popStackParameter("isInLink");
        stack.popStackParameter("isFreeStandingLink");
        stack.popStackParameter("linkParameters");
    }

    private void handleImageCommentStart(String content, XhtmlHandler.TagStack stack) {
        stack.setStackParameter("isInImage", (Object)true);
        this.commentContentStack.push(content.substring("startimage:".length()));
    }

    private void handleImageCommentStop(String content, XhtmlHandler.TagStack stack) {
        boolean isFreeStandingImage = (Boolean)stack.getStackParameter("isFreeStandingImage");
        WikiParameters parameters = (WikiParameters)stack.getStackParameter("imageParameters");
        String imageComment = this.commentContentStack.pop();
        Image image = this.imageParser.parse(imageComment);
        if (isFreeStandingImage) {
            stack.getScannerContext().onImage(imageComment);
        } else {
            WikiParameter alt = parameters.getParameter("alt");
            if (alt != null && alt.getValue().equals(image.getName())) {
                parameters = parameters.remove("alt");
            }
            WikiReference reference = new WikiReference(imageComment, null, parameters);
            stack.getScannerContext().onImage(reference);
        }
        stack.setStackParameter("isInImage", (Object)false);
        stack.setStackParameter("isFreeStandingImage", (Object)false);
        stack.setStackParameter("imageParameters", (Object)WikiParameters.EMPTY);
    }
}

