/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.Value;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Watch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String FAQ_APP = "faqApp".intern();
    public static final String DEFAULT_AVATAR_URL = "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
    public static final String QUESTION_HOME = "questions".intern();
    public static final String CATEGORY_HOME = "categories";
    public static final String ANSWER_HOME = "faqAnswerHome".intern();
    public static final String COMMENT_HOME = "faqCommentHome".intern();
    public static final String LANGUAGE_HOME = "languages".intern();
    public static final String EXO_FAQQUESTIONHOME = "exo:faqQuestionHome".intern();
    public static final String EXO_FAQCATEGORYHOME = "exo:faqCategoryHome".intern();
    public static final String ALL = "All".intern();
    public static final String CATE_SPACE_ID_PREFIX = "CategorySpace".intern();
    public static final String UI_FAQ_VIEWER = "UIFAQViewer".intern();
    public static final String DELETED = ":deleted".intern();

    public static String[] splitForFAQ(String str) throws Exception {
        if (str != null && str.length() > 0) {
            if (str.contains(",")) {
                return str.trim().split(",");
            }
            return str.trim().split(";");
        }
        return new String[0];
    }

    public static String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < Val.length; ++i) {
            String s = Val[i].getString();
            if (s == null || s.trim().length() <= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (s == null || s.trim().length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    public static boolean hasPermission(List<String> listPlugin, List<String> listOfUser) {
        ArrayList<String> tem = new ArrayList<String>();
        for (String str : listOfUser) {
            if (listPlugin.contains(str)) {
                return true;
            }
            if (!str.contains("*")) continue;
            str = str.substring(str.indexOf("/"), str.length());
            tem.add(str);
            if (!listPlugin.contains(str)) continue;
            return true;
        }
        for (String s : listPlugin) {
            if (!tem.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static String getStandardId(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int t = s.codePointAt(i);
            if (t > 48 && t < 122) {
                builder.append(s.charAt(i));
                continue;
            }
            builder.append("id");
        }
        return builder.toString();
    }

    public static String[] compareStr(String[] arr1, String[] arr2) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(arr1));
        if (list.isEmpty() || ((String)list.get(0)).equals(" ")) {
            return new String[]{" "};
        }
        for (int i = 0; i < arr2.length; ++i) {
            if (list.contains(arr2[i])) continue;
            list.add(arr2[i]);
        }
        return list.toArray(new String[0]);
    }

    public static long getTimeOfLastActivity(String info) {
        if (info == null || info.length() == 0) {
            return -1L;
        }
        int dashIndex = info.lastIndexOf("-");
        if (dashIndex < 0) {
            return -1L;
        }
        try {
            return Long.parseLong(info.substring(dashIndex + 1));
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static String getAuthorOfLastActivity(String info) {
        if (info == null || info.length() == 0) {
            return null;
        }
        int dashIndex = info.lastIndexOf("-");
        if (dashIndex < 0) {
            return null;
        }
        return info.substring(0, dashIndex);
    }

    public static String getOderBy(FAQSetting faqSetting) {
        StringBuffer queryString = new StringBuffer();
        if (faqSetting.isSortQuestionByVote()) {
            queryString.append("@").append("exo:markVote").append(FAQSetting.ORDERBY_DESC).append(", ");
        }
        if (faqSetting.getOrderBy().equals(FAQSetting.DISPLAY_TYPE_POSTDATE)) {
            queryString.append("@").append("exo:createdDate");
        } else {
            queryString.append("@").append("exo:title");
        }
        if (faqSetting.getOrderType().equals(FAQSetting.ORDERBY_TYPE_ASC)) {
            queryString.append(FAQSetting.ORDERBY_ASC);
        } else {
            queryString.append(FAQSetting.ORDERBY_DESC);
        }
        return queryString.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Watch)o1).getUser();
            String name2 = ((Watch)o2).getUser();
            return name1.compareToIgnoreCase(name2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Category)o1).getName();
            String name2 = ((Category)o2).getName();
            return name2.compareToIgnoreCase(name1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatetimeComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((Category)o1).getCreatedDate();
            Date date2 = ((Category)o2).getCreatedDate();
            return date2.compareTo(date1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparatorASC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Category)o1).getName();
            String name2 = ((Category)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatetimeComparatorASC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((Category)o1).getCreatedDate();
            Date date2 = ((Category)o2).getCreatedDate();
            return date1.compareTo(date2);
        }
    }
}

