/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumServiceUtils {
    private static final Log log = ExoLogger.getLogger(ForumServiceUtils.class);

    public static boolean hasPermission(String[] userGroupMembership, String userId) throws Exception {
        IdentityRegistry identityRegistry = (IdentityRegistry)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            Collection memberships = oService.getMembershipHandler().findMembershipsByUser(userId);
            identity = new Identity(userId, memberships);
        }
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership[0].equals(" ")) {
            return false;
        }
        for (String item : userGroupMembership) {
            String username;
            String group;
            String membershipType;
            String[] array;
            String group2;
            String expr = item.trim();
            if (!(ForumServiceUtils.isMembershipExpression(expr) ? identity.isMemberOf(group2 = (array = expr.split(":"))[1], membershipType = array[0]) : (ForumServiceUtils.isGroupExpression(expr) ? identity.isMemberOf(group = expr) : (username = expr).equals(userId)))) continue;
            return true;
        }
        return false;
    }

    private static boolean isGroupExpression(String expr) {
        return expr.indexOf("/") >= 0 && expr.indexOf(":") < 0;
    }

    private static boolean isMembershipExpression(String expr) {
        return expr.indexOf("/") >= 0 && expr.indexOf(":") >= 0;
    }

    private static PageList getUserByGroup(OrganizationService organizationService, String group) throws Exception {
        try {
            return organizationService.getUserHandler().findUsersByGroup(group);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> getUserPermission(String[] userGroupMembership) throws Exception {
        List<String> users = ForumServiceUtils.getFromCache(userGroupMembership);
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership.length == 1 && userGroupMembership[0].equals(" ")) {
            return users;
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        for (String str : userGroupMembership) {
            if (ForumServiceUtils.isMembershipExpression(str = str.trim())) {
                int i;
                String[] array = str.split(":");
                PageList pageList = ForumServiceUtils.getUserByGroup(organizationService, array[1]);
                if (pageList == null) continue;
                if (array[0].length() > 1) {
                    ArrayList userList = new ArrayList();
                    for (i = 1; i <= pageList.getAvailablePage(); ++i) {
                        userList.clear();
                        userList.addAll(pageList.getPage(i));
                        block2: for (User user : userList) {
                            if (users.contains(user.getUserName())) continue;
                            Collection memberships = organizationService.getMembershipHandler().findMembershipsByUser(user.getUserName());
                            for (Membership member : memberships) {
                                if (!member.getMembershipType().equals(array[0])) continue;
                                users.add(user.getUserName());
                                continue block2;
                            }
                        }
                    }
                    continue;
                }
                if (array[0].charAt(0) != '*' || (pageList = ForumServiceUtils.getUserByGroup(organizationService, array[1])) == null) continue;
                ArrayList userList = new ArrayList();
                for (i = 1; i <= pageList.getAvailablePage(); ++i) {
                    userList.clear();
                    userList.addAll(pageList.getPage(i));
                    for (User user : userList) {
                        if (users.contains(user.getUserName())) continue;
                        users.add(user.getUserName());
                    }
                }
                continue;
            }
            if (ForumServiceUtils.isGroupExpression(str)) {
                PageList pageList = ForumServiceUtils.getUserByGroup(organizationService, str);
                if (pageList == null) continue;
                ArrayList userList = new ArrayList();
                for (int i = 1; i <= pageList.getAvailablePage(); ++i) {
                    userList.clear();
                    userList.addAll(pageList.getPage(i));
                    for (User user : userList) {
                        if (users.contains(user.getUserName())) continue;
                        users.add(user.getUserName());
                    }
                }
                continue;
            }
            if (users.contains(str)) continue;
            users.add(str);
        }
        ForumServiceUtils.storeInCache(userGroupMembership, users);
        return users;
    }

    private static void storeInCache(String[] userGroupMembership, List<String> users) throws Exception {
        ExoCache cache = ForumServiceUtils.getCache();
        Serializable cacheKey = ForumServiceUtils.getCacheKey(userGroupMembership);
        cache.put(cacheKey, users);
    }

    private static List<String> getFromCache(String[] userGroupMembership) throws Exception {
        if (userGroupMembership == null || userGroupMembership.length == 0 || userGroupMembership.length == 1 && userGroupMembership[0].length() == 0) {
            return null;
        }
        ExoCache cache = ForumServiceUtils.getCache();
        Serializable cacheKey = ForumServiceUtils.getCacheKey(userGroupMembership);
        return (List)cache.get(cacheKey);
    }

    private static Serializable getCacheKey(String[] userGroupMembership) {
        StringBuilder sb = new StringBuilder();
        for (String item : userGroupMembership) {
            sb.append("#").append(item);
        }
        return sb.toString();
    }

    private static ExoCache getCache() throws Exception {
        CacheService cacheService = (CacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CacheService.class);
        return cacheService.getCacheInstance("org.exoplatform.forum.ForumPermissionsUsers");
    }

    public static void reparePermissions(Node node, String owner) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(owner, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
    }

    public static SessionProvider getSessionProvider() {
        return SessionProvider.createSystemProvider();
    }

    public static SessionManager getSessionManager() {
        KSDataLocation location = (KSDataLocation)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(KSDataLocation.class);
        return location.getSessionManager();
    }
}

