/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.page.UIPagePreview;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.page.UIPageWizard;
import org.exoplatform.portal.webui.page.UIWizardPageSelectLayoutForm;
import org.exoplatform.portal.webui.page.UIWizardPageSetInfo;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/webui/core/UIWizard.gtmpl", events={@EventConfig(listeners={ViewStep1ActionListener.class}), @EventConfig(listeners={ViewStep2ActionListener.class}), @EventConfig(listeners={ViewStep3ActionListener.class}), @EventConfig(listeners={ViewStep4ActionListener.class}), @EventConfig(listeners={UIPageWizard.AbortActionListener.class})})})
public class UIPageCreationWizard
extends UIPageWizard {
    public static final int FIRST_STEP = 1;
    public static final int SECOND_STEP = 2;
    public static final int THIRD_STEP = 3;
    public static final int NUMBER_OF_STEPs = 3;

    public UIPageCreationWizard() throws Exception {
        ((UIWizardPageSetInfo)this.addChild(UIWizardPageSetInfo.class, null, null)).setRendered(false);
        ((UIWizardPageSelectLayoutForm)this.addChild(UIWizardPageSelectLayoutForm.class, null, null)).setRendered(false);
        ((UIPagePreview)this.addChild(UIPagePreview.class, null, null)).setRendered(false);
        this.setNumberSteps(3);
        this.viewStep(1);
        this.setShowWelcomeComponent(false);
    }

    public void configure(UserNode node) throws Exception {
        UIPageNodeSelector nodeSelector = (UIPageNodeSelector)this.findFirstComponentOfType(UIPageNodeSelector.class);
        nodeSelector.configure(node);
        if (node.getNavigation().getKey().getType().equals((Object)SiteType.USER)) {
            nodeSelector.setRendered(false);
        }
    }

    private UserNode saveData() throws Exception {
        UIPagePreview uiPagePreview = (UIPagePreview)this.getChild(UIPagePreview.class);
        UIPage uiPage = (UIPage)uiPagePreview.getUIComponent();
        UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)this.getChild(UIWizardPageSetInfo.class);
        UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
        UserNode selectedNode = uiNodeSelector.getSelectedNode();
        Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
        UserNode createdNode = uiPageInfo.createUserNode(selectedNode);
        createdNode.setPageRef(page.getPageId());
        DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
        dataService.create(page);
        UserPortal userPortal = Util.getUIPortalApplication().getUserPortalConfig().getUserPortal();
        userPortal.saveNode(selectedNode, null);
        DescriptionService descriptionService = (DescriptionService)this.getApplicationComponent(DescriptionService.class);
        HashMap<Locale, Described.State> descriptions = new HashMap<Locale, Described.State>();
        Map<String, String> cachedLabels = uiPageInfo.getCachedLabels();
        for (String strLocale : cachedLabels.keySet()) {
            String[] arr;
            Locale locale = strLocale.contains("_") ? ((arr = strLocale.split("_")).length > 2 ? new Locale(arr[0], arr[1], arr[2]) : new Locale(arr[0], arr[1])) : new Locale(strLocale);
            descriptions.put(locale, new Described.State(cachedLabels.get(strLocale), null));
        }
        descriptionService.setDescriptions(createdNode.getId(), descriptions);
        return createdNode;
    }

    private boolean isSelectedNodeExist() throws Exception {
        UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)this.getChild(UIWizardPageSetInfo.class);
        String pageName = (String)uiPageSetInfo.getUIStringInput("pageName").getValue();
        UserNode selectedPageNode = uiPageSetInfo.getSelectedPageNode();
        return selectedPageNode.getChild(pageName) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep4ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            uiWizard.setShowActions(true);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
            if (uiWizard.isSelectedNodeExist()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            uiPortalApp.setModeState(0);
            uiWorkingWS.setRenderedChild("UIViewWS");
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            try {
                UserNode newNode = uiWizard.saveData();
                NodeURL nodeURL = ((NodeURL)pcontext.createURL(NodeURL.TYPE)).setNode(newNode);
                UIPortalToolPanel toolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
                toolPanel.setUIComponent(null);
                uiWizard.updateUIPortal(event);
                pcontext.sendRedirect(nodeURL.toString());
            }
            catch (NavigationServiceException ex) {
                pcontext.getUIApplication().addMessage(new ApplicationMessage("UIPageCreationWizard.msg." + ex.getError().name(), null));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep3ActionListener
    extends EventListener<UIPageCreationWizard> {
        private void setDefaultPermission(Page page, SiteKey siteKey) {
            UIPortal uiPortal = Util.getUIPortal();
            if (SiteType.PORTAL.equals((Object)siteKey.getType())) {
                page.setAccessPermissions(uiPortal.getAccessPermissions());
                page.setEditPermission(uiPortal.getEditPermission());
            } else if (SiteType.GROUP.equals((Object)siteKey.getType())) {
                UserACL acl = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
                String siteName = siteKey.getName().startsWith("/") ? siteKey.getName() : "/" + siteKey.getName();
                page.setAccessPermissions(new String[]{"*:" + siteName});
                page.setEditPermission(acl.getMakableMT() + ":" + siteName);
            }
        }

        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            uiWizard.setShowActions(false);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            PortalRequestContext context = Util.getPortalRequestContext();
            if (uiWizard.isSelectedNodeExist()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            uiWizard.viewStep(3);
            if (uiWizard.getSelectedStep() < 3) {
                uiWizard.setShowActions(true);
                uiWizard.updateWizardComponent();
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.StepByStep", null));
                return;
            }
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
            UIPageTemplateOptions uiPageTemplateOptions = (UIPageTemplateOptions)uiWizard.findFirstComponentOfType(UIPageTemplateOptions.class);
            UIWizardPageSetInfo uiPageInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageInfo.getChild(UIPageNodeSelector.class);
            UserNavigation pageNavi = uiNodeSelector.getNavigation();
            String ownerType = pageNavi.getKey().getTypeName();
            String ownerId = pageNavi.getKey().getName();
            UIFormStringInput pageName = uiPageInfo.getUIStringInput("pageName");
            Page page = uiPageTemplateOptions.createPageFromSelectedOption(ownerType, ownerId);
            page.setName("page" + page.hashCode());
            String pageId = ownerType + "::" + ownerId + "::" + page.getName();
            DataStorage storage = (DataStorage)uiWizard.getApplicationComponent(DataStorage.class);
            if (storage.getPage(pageId) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
            }
            page.setModifiable(true);
            this.setDefaultPermission(page, pageNavi.getKey());
            if (page.getTitle() == null || page.getTitle().trim().length() == 0) {
                page.setTitle((String)pageName.getValue());
            }
            UIPagePreview uiPagePreview = (UIPagePreview)uiWizard.getChild(UIPagePreview.class);
            UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
            UIPage uiPage = clazz.createUIPage(context);
            PortalDataMapper.toUIPage(uiPage, page);
            uiPagePreview.setUIComponent((UIComponent)uiPage);
            uiWizard.updateWizardComponent();
            uiPageTemplateOptions.setSelectedOption(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep2ActionListener
    extends EventListener<UIPageCreationWizard> {
        public void execute(Event<UIPageCreationWizard> event) throws Exception {
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)((Object)event.getSource());
            uiWizard.setShowActions(true);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiWizard.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
            uiWizard.viewStep(2);
            if (uiWizard.getSelectedStep() < 2) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.StepByStep", null));
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            if (uiWizard.isSelectedNodeExist()) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.NameNotSame", null));
                uiWizard.viewStep(1);
                uiWizard.updateWizardComponent();
                return;
            }
            UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)uiPageSetInfo.getChild(UIPageNodeSelector.class);
            uiWizard.updateWizardComponent();
            UserNavigation navigation = uiNodeSelector.getNavigation();
            if (navigation == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageCreationWizard.msg.notSelectedPageNavigation", (Object[])new String[0]));
                uiWizard.viewStep(1);
                return;
            }
            if (uiPageSetInfo.getUICheckBoxInput("showPublicationDate").isChecked()) {
                Date endDate;
                Calendar currentCalendar = Calendar.getInstance();
                currentCalendar.set(currentCalendar.get(1), currentCalendar.get(2), currentCalendar.get(5), 0, 0, 0);
                Date currentDate = currentCalendar.getTime();
                Calendar startCalendar = uiPageSetInfo.getUIFormDateTimeInput("startPublicationDate").getCalendar();
                Date startDate = startCalendar != null ? startCalendar.getTime() : currentDate;
                Calendar endCalendar = uiPageSetInfo.getUIFormDateTimeInput("endPublicationDate").getCalendar();
                Date date = endDate = endCalendar != null ? endCalendar.getTime() : null;
                if (currentDate.after(startDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.currentDateBeforeStartDate", args, 1));
                    uiWizard.viewStep(1);
                    return;
                }
                if (endCalendar != null && startCalendar != null && startDate.after(endDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.startDateBeforeEndDate", args, 1));
                    uiWizard.viewStep(1);
                    return;
                }
                if (endCalendar != null && currentDate.after(endDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.currentDateBeforeEndDate", args, 1));
                    uiWizard.viewStep(1);
                    return;
                }
            }
            UIFormStringInput label = uiPageSetInfo.getUIStringInput("i18nizedLabel");
            uiPageSetInfo.updateCachedLabels(uiPageSetInfo.getSelectedLocale(), (String)label.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep1ActionListener
    extends EventListener<UIPageWizard> {
        public void execute(Event<UIPageWizard> event) throws Exception {
            UIPageWizard uiWizard = (UIPageWizard)((Object)event.getSource());
            uiWizard.updateWizardComponent();
            uiWizard.viewStep(1);
            uiWizard.setShowActions(true);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiWizard.getAncestorOfType(UIWorkingWorkspace.class);
            ((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(false);
        }
    }
}

