/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.bench;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/bench")
public class DataInjectorService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(DataInjectorService.class);
    private static CacheControl cc = new CacheControl();
    private List<DataInjector> listOfInjectors = new LinkedList<DataInjector>();

    private InitParams initParams(MultivaluedMap<String, String> paramsMap) {
        InitParams initParams = new InitParams();
        for (Map.Entry entry : paramsMap.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            String value = values.size() > 0 ? (String)values.get(0) : null;
            ValueParam valueParam = new ValueParam();
            valueParam.setValue(value);
            initParams.put((Object)key, (Object)valueParam);
        }
        return initParams;
    }

    private DataInjector getDataInjector(String injectorId) {
        for (DataInjector di : this.listOfInjectors) {
            if (!injectorId.equals(di.getName())) continue;
            return di;
        }
        return null;
    }

    public void addInjector(DataInjector dataInjector) {
        this.listOfInjectors.add(dataInjector);
    }

    @GET
    @Path(value="/inject/{injectorId}")
    @RolesAllowed(value={"administrators"})
    public Response inject(@PathParam(value="injectorId") String type, @Context UriInfo info) {
        DataInjector injector = this.getDataInjector(type);
        if (injector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Injector id is not properly!").cacheControl(cc).build();
        }
        InitParams params = this.initParams((MultivaluedMap<String, String>)info.getQueryParameters());
        injector.initParams(params);
        if (!injector.isInitialized()) {
            try {
                injector.inject();
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("%s injected failed", injector.getName()), (Throwable)e);
                }
                return Response.serverError().entity((Object)String.format("%1$s injected failed due to %2$s", injector.getName(), e.getMessage())).build();
            }
            return Response.ok((Object)String.format("%s injected successfully!!!", injector.getName()), (String)"text/plain").cacheControl(cc).build();
        }
        return Response.ok((Object)String.format("Injector %s has been executed before. Skipping!!!", injector.getName()), (String)"text/plain").cacheControl(cc).build();
    }

    @GET
    @Path(value="/reject/{injectorId}")
    @RolesAllowed(value={"administrators"})
    public Response reject(@PathParam(value="injectorId") String type, @Context UriInfo info) {
        DataInjector injector = this.getDataInjector(type);
        if (injector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Injector id is missed").cacheControl(cc).build();
        }
        InitParams params = this.initParams((MultivaluedMap<String, String>)info.getQueryParameters());
        injector.initParams(params);
        try {
            injector.reject();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("%s rejected failed", injector.getName()), (Throwable)e);
            }
            return Response.serverError().entity((Object)String.format("%1$s rejected failed due to %2$s", injector.getName(), e.getMessage())).build();
        }
        return Response.ok((Object)String.format("%s rejected successfully!!!", injector.getName()), (String)"text/plain").cacheControl(cc).build();
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

