/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.templates.LocalizedHtml;
import com.google.caja.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class LocalizedHtmlTest
extends TestCase {
    public final void testEmptyMessage() throws Exception {
        this.runTest("", "", "");
    }

    public final void testSimpleMessage() throws Exception {
        this.runTest("Hello, World!", "Hello, World!", "Hello, World!");
    }

    public final void testMessageWithPlaceholder1() throws Exception {
        this.runTest("Hello, PLANET!", "Hello, &lt;PLANET&gt;!", "Hello, <ihtml:ph name='planet'/>!");
    }

    public final void testMessageWithPlaceholder2() throws Exception {
        this.runTest("Hello, <b>PLANET</b>!", "Hello, <b>&lt;PLANET&gt;</b>!", "Hello, <ihtml:ph name='b_planet'/>!");
    }

    public final void testMessageWithPlaceholders() throws Exception {
        this.runTest("GREETING, <b>PLANET</b>!", "&lt;GREETING&gt;, <b>&lt;PLANET&gt;</b>!", "<ihtml:ph name='greeting'/>, <ihtml:ph name='b_planet'/>!");
    }

    private void runTest(String golden1, String golden2, String input) throws Exception {
        LocalizedHtml msg = new LocalizedHtml("test", input);
        Document doc = DomParser.makeDocument(null, null);
        DocumentFragment f1 = msg.substitute(doc, new LocalizedHtml.PlaceholderHandler(){

            @Override
            public Iterator<Token<HtmlTokenType>> substitutePlaceholder(String placeholderName, FilePosition placeholderLoc) {
                String uname = Strings.toUpperCase(placeholderName);
                FilePosition unk = FilePosition.UNKNOWN;
                ArrayList<Token<HtmlTokenType>> toks = new ArrayList<Token<HtmlTokenType>>();
                if (placeholderName.startsWith("b_")) {
                    toks.add(Token.instance("<b", HtmlTokenType.TAGBEGIN, unk));
                    toks.add(Token.instance(">", HtmlTokenType.TAGEND, unk));
                    toks.add(Token.instance(uname.substring(2), HtmlTokenType.TEXT, unk));
                    toks.add(Token.instance("</b", HtmlTokenType.TAGBEGIN, unk));
                    toks.add(Token.instance(">", HtmlTokenType.TAGEND, unk));
                } else {
                    toks.add(Token.instance(uname, HtmlTokenType.TEXT, unk));
                }
                return toks.iterator();
            }
        });
        String actual1 = Nodes.render(f1);
        LocalizedHtmlTest.assertEquals((String)actual1, (String)golden1, (String)actual1);
        DocumentFragment f2 = msg.substitute(doc, new LocalizedHtml.PlaceholderHandler(){

            @Override
            public Iterator<Token<HtmlTokenType>> substitutePlaceholder(String placeholderName, FilePosition placeholderLoc) {
                String uname = Strings.toUpperCase(placeholderName);
                FilePosition unk = FilePosition.UNKNOWN;
                ArrayList<Token<HtmlTokenType>> toks = new ArrayList<Token<HtmlTokenType>>();
                if (placeholderName.startsWith("b_")) {
                    toks.add(Token.instance("<b", HtmlTokenType.TAGBEGIN, unk));
                    toks.add(Token.instance(">", HtmlTokenType.TAGEND, unk));
                    toks.add(Token.instance("<" + uname.substring(2) + ">", HtmlTokenType.TEXT, unk));
                    toks.add(Token.instance("</b", HtmlTokenType.TAGBEGIN, unk));
                    toks.add(Token.instance(">", HtmlTokenType.TAGEND, unk));
                } else {
                    toks.add(Token.instance("<" + uname + ">", HtmlTokenType.TEXT, unk));
                }
                return toks.iterator();
            }
        });
        String actual2 = Nodes.render(f2);
        LocalizedHtmlTest.assertEquals((String)actual2, (String)golden2, (String)actual2);
    }
}

