/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.exoplatform.services.jcr.impl.core.query.lucene.TextExtractorReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyTextExtractorField
extends AbstractField {
    private static final long serialVersionUID = -2707986404659820071L;
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.LazyTextExtractorField");
    private final Reader reader;
    private volatile String extract;

    public LazyTextExtractorField(String name, Reader reader, boolean store, boolean withOffsets) {
        super(name, store ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, withOffsets ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO);
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String stringValue() {
        block13: {
            if (this.extract != null) break block13;
            LazyTextExtractorField lazyTextExtractorField = this;
            synchronized (lazyTextExtractorField) {
                StringBuilder textExtract;
                block14: {
                    int len;
                    if (this.extract != null) break block13;
                    textExtract = new StringBuilder();
                    char[] buffer = new char[1024];
                    while ((len = this.reader.read(buffer)) > -1) {
                        textExtract.append(buffer, 0, len);
                    }
                    Object var8_5 = null;
                    try {
                        this.reader.close();
                    }
                    catch (IOException e2) {
                        log.error(e2.getLocalizedMessage(), (Throwable)e2);
                    }
                    break block14;
                    {
                        catch (IOException e) {
                            Throwable cause = e;
                            if ((e.getMessage() == null || e.getMessage().isEmpty()) && e.getCause() != null) {
                                cause = e.getCause();
                            }
                            log.warn("Exception while reading the value of the  field: '" + this.name + "': " + cause);
                            log.debug("Dump:", (Throwable)e);
                            Object var8_6 = null;
                            try {
                                this.reader.close();
                            }
                            catch (IOException e2) {
                                log.error(e2.getLocalizedMessage(), (Throwable)e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        try {
                            this.reader.close();
                        }
                        catch (IOException e2) {
                            log.error(e2.getLocalizedMessage(), (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                this.extract = textExtract.toString();
            }
        }
        return this.extract;
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        return null;
    }

    public boolean isExtractorFinished() {
        if (this.reader instanceof TextExtractorReader) {
            return ((TextExtractorReader)this.reader).isExtractorFinished();
        }
        return true;
    }

    public void dispose() throws IOException {
        this.reader.close();
    }
}

