/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import org.mortbay.log.Log;

public class Timeout {
    private long _duration;
    private long _now = System.currentTimeMillis();
    private Task _head = new Task();

    public Timeout() {
        this._head._timeout = this;
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long duration) {
        this._duration = duration;
    }

    public void setNow() {
        this._now = System.currentTimeMillis();
    }

    public long getNow() {
        return this._now;
    }

    public void setNow(long now) {
        this._now = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task expired() {
        long _expiry = this._now - this._duration;
        if (this._head._next != this._head) {
            Task task = this._head._next;
            if (task._timestamp > _expiry) {
                return null;
            }
            Task task2 = task;
            synchronized (task2) {
                task.unlink();
                task._expired = true;
            }
            return task;
        }
        return null;
    }

    public void tick() {
        long _expiry = this._now - this._duration;
        while (this._head._next != this._head) {
            Task task = this._head._next;
            if (task._timestamp > _expiry) break;
            try {
                task.doExpire();
            }
            catch (Throwable th) {
                Log.warn("EXCEPTION ", th);
            }
        }
    }

    public void schedule(Task task) {
        this.schedule(task, 0L);
    }

    public void schedule(Task task, long delay) {
        if (task._timestamp != 0L) {
            task.unlink();
            task._timestamp = 0L;
        }
        task._expired = false;
        task._delay = delay;
        task._timestamp = delay == 0L ? this._now + delay : this._now - this._duration + delay;
        Task last = this._head._prev;
        while (last != this._head && last._timestamp > task._timestamp) {
            last = last._prev;
        }
        last.setNext(task);
    }

    public void cancelAll() {
        this._head._next = this._head._prev = this._head;
    }

    public boolean isEmpty() {
        return this._head._next == this._head;
    }

    public long getTimeToNext() {
        if (this._head._next == this._head) {
            return -1L;
        }
        long to_next = this._duration + this._head._next._timestamp - this._now;
        return to_next < 0L ? 0L : to_next;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        Task task = this._head._next;
        while (task != this._head) {
            buf.append("-->");
            buf.append(task);
            task = task._next;
        }
        return buf.toString();
    }

    public static class Task {
        Task _next = this._prev = this;
        Task _prev;
        Timeout _timeout;
        long _delay;
        long _timestamp = 0L;
        boolean _expired = false;

        public long getTimestamp() {
            return this._timestamp;
        }

        public long getAge() {
            Timeout t = this._timeout;
            if (t != null && t._now != 0L && this._timestamp != 0L) {
                return t._now - this._timestamp;
            }
            return 0L;
        }

        public void unlink() {
            this._next._prev = this._prev;
            this._prev._next = this._next;
            this._next = this._prev = this;
            this._timeout = null;
            this._expired = false;
        }

        public void setNext(Task task) {
            if (this._timeout == null || task._timeout != null && task._timeout != this._timeout || task._next != task) {
                throw new IllegalStateException();
            }
            Task next_next = this._next;
            this._next._prev = task;
            this._next = task;
            this._next._next = next_next;
            this._next._prev = this;
            this._next._timeout = this._timeout;
        }

        public void schedule(Timeout timer) {
            this.unlink();
            timer.schedule(this);
        }

        public void schedule(Timeout timer, long delay) {
            this.unlink();
            timer.schedule(this, delay);
        }

        public void reschedule() {
            Timeout timer = this._timeout;
            this.unlink();
            timer.schedule(this, this._delay);
        }

        public void cancel() {
            this._timestamp = 0L;
            this.unlink();
        }

        public boolean isExpired() {
            return this._expired;
        }

        public boolean isScheduled() {
            return this._next != this;
        }

        public void expire() {
        }

        public void expired() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doExpire() {
            try {
                Task task = this;
                synchronized (task) {
                    this.unlink();
                    this._expired = true;
                    this.expire();
                }
            }
            finally {
                this.expired();
            }
        }
    }
}

