/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Executor;
import com.google.caja.util.RhinoTestBed;
import junit.framework.AssertionFailedError;

public class CajitaTest
extends CajaTestCase {
    public final void testAllKeys() throws Exception {
        this.runTest("try {  var x = cajita.allKeys(undefined);} catch (e) {  fail('should be allowed to enumerate properties of undefined');}");
        this.runTest("try {  var x = cajita.allKeys(null);} catch (e) {  fail('should be allowed to enumerate properties of null');}");
        this.runTest("try {  var x = cajita.allKeys(false);} catch (e) {  fail('should be allowed to enumerate properties of false');}");
        this.runTest("try {  var x = cajita.allKeys(0);} catch (e) {  fail('should be allowed to enumerate properties of zero');}");
        this.runTest("try {  var x = cajita.allKeys('');} catch (e) {  fail('should be allowed to enumerate properties of empty string');}");
        this.runTest("try {  var x = cajita.allKeys({y:1, z:2}).sort();} catch (e) {  fail('should be allowed to enumerate properties of an object');}assertTrue(x[0] === 'y' && x[1] === 'z');");
    }

    public final void testGrantFunc() throws Exception {
        this.runTest("  var o = { f: function(x) { this.x = x; } };___.grantFunc(o, 'f');assertTrue(___.isFunc(o.f));___.asFunc(o.f);assertEquals(42, ___.construct(o.f, [42]).x);");
    }

    public final void testGrantGeneric() throws Exception {
        this.runTest("  function A() {} function B() {} function C() {}var f = function(x) { this.x = x; };A.prototype.f = B.prototype.f = f;___.grantGenericMethod(A.prototype, 'f');var a = new A(), b = new B(), c = new C();___.callPub(a, 'f', [42]); assertEquals(42, a.x);assertThrows(function() { ___.callPub(b, 'f', [42]); });assertThrows(function() { ___.callPub(c, 'f', [42]); });");
    }

    public final void testJsonParse() throws Exception {
        this.runTest("function hop(o, k) {\n  return ___.hasOwnProp(o, k); \n}\nvar safeJSON = ___.sharedImports.JSON; \nassertEquals('foo', safeJSON.parse('{ \"bar\": \"foo\" }').bar); \nvar o1 = {}, o2 = {}, o3 = {}; \ntry { \n  o1 = safeJSON.parse('{ \"f___\": 1 }'); \n} catch (e) {} \ntry { \n  o2 = safeJSON.parse('{ \"valueOf\": true }'); \n} catch (e) {} \ntry { \n  o3 = safeJSON.parse('{ \"toString\": true }'); \n} catch (e) {} \nassertFalse(hop(o1, 'f___')); \nassertFalse(hop(o1, 'valueOf')); \nassertFalse(hop(o1, 'toString')); \n");
    }

    public final void testIssue1190() throws Exception {
        this.runTest("var x = safeJSON.parse('{\"a\":1, \"b\":2}');\nvar s = safeJSON.stringify(x);\nassertEquals('{\"a\":1,\"b\":2}', s);\n");
        this.runTest("var x = safeJSON.parse('{\"a\":1, \"b\":\"__proto__\"}');\nvar s = safeJSON.stringify(x);\nassertEquals('{\"a\":1,\"b\":\"__proto__\"}', s);\n");
        this.assertQuestionableJson("{'a': 1, 'b___': 2}".replace('\'', '\"'), "{'a':1}".replace('\'', '\"'));
        this.assertQuestionableJson("{'a': 1, 'b_\\u005f_': {'b': [1,2]}, 'c': [0.1]}".replace('\'', '\"'), "{'a':1,'c':[0.1]}".replace('\'', '\"'));
        this.assertBadJson("{'a': 1, 'b_\\x5f_': 2}".replace('\'', '\"'));
        this.assertBadJson("{'a': 1, 'b_\\137_': 2}".replace('\'', '\"'));
        this.assertBadJson("{'a': 1, b_\\x5f_: 2}".replace('\'', '\"'));
        this.assertBadJson("{'a': 1, b_\\137_: 2}".replace('\'', '\"'));
        this.assertBadJson("{'a': 1, 'b': 2".replace('\'', '\"'));
        this.assertBadJson("{'a': 1, 'b': 2".replace('\'', '\"'));
        this.assertBadJson("___");
        this.assertQuestionableJson("[___]", "[]");
        this.runTest("var s;\ntry {\n  var x = safeJSON.parse('[\"a\":1, \"b__\":\"__proto__\"}');\n  s = safeJSON.stringify(x);\n} catch (e) {\n  s = void 0;\n}\nif (s !== void 0) {\n  assertEquals('[\"a\",1,\"b__\",\"__proto__\"]', s);\n}");
        this.runTest("var s;\ntry {\n  var x = safeJSON.parse('{\"a\": [2}, \"c___\": 3}');\n  s = safeJSON.stringify(x);\n} catch (e) {\n  s = void 0;\n}\nif (s !== void 0) {\n  assertEquals('{\"a\":[2]}', s);\n}");
    }

    public final void testReplacers() throws Exception {
        this.runTest("var o = { z___: 3 };\n___.setPub(o, 'x', 1);\n___.setPub(o, 'y', -2);\nvar keysSeen = [];\nfunction f(key, value) {\n  keysSeen.push(key);\n  return key === '' ? value : -value;\n}\nassertEquals(\n    '{\"x\":-1,\"y\":2}',\n    safeJSON.stringify(o, ___.markFuncFreeze(f)));\nassertEquals(',x,y', '' + keysSeen);");
    }

    public final void testRevivers() throws Exception {
        this.runTest("var s = '[ { \"millis\": 0 }, { \"millis\": 1000 } ]';\nvar keysSeen = [];\nfunction f(key, val) {\n  keysSeen.push(key);\n  if (typeof val === 'object' && typeof val.millis === 'number') {\n    var d = new Date(val.millis);\n    d.millis__ = val.millis;\n    return d;\n  }\n  return val;\n}\nvar arr = safeJSON.parse(s, ___.markFuncFreeze(f));\nassertEquals('millis,0,millis,1,', '' + keysSeen);\nassertTrue('is array', arr instanceof Array);\nassertEquals('arr.length', 2, arr.length);\nassertTrue('Date 0', arr[0] instanceof Date);\nassertTrue('Date 1', arr[1] instanceof Date);\nassertEquals(0, arr[0].getTime());\nassertEquals(1000, arr[1].getTime());\n");
    }

    private void assertQuestionableJson(String json, String ok) throws Exception {
        StringBuilder escapedJson = new StringBuilder();
        Escaping.escapeJsString((CharSequence)json, false, false, escapedJson);
        StringBuilder escapedOk = new StringBuilder();
        Escaping.escapeJsString((CharSequence)ok, false, false, escapedOk);
        this.runTest("(function () {\n  var obj = null;\n  try {\n    obj = safeJSON.parse('" + escapedJson + "');\n" + "  } catch (e) {\n" + "    return;\n" + "  }\n" + "  assertEquals('" + escapedOk + "', JSON.stringify(obj));\n" + "})();");
    }

    private void assertBadJson(String json) throws Exception {
        StringBuilder escapedJson = new StringBuilder();
        Escaping.escapeJsString((CharSequence)json, false, false, escapedJson);
        this.runTest("var ok = false;\ntry {\n  safeJSON.parse('" + escapedJson + "');\n" + "} catch (e) {\n" + "  ok = true;\n" + "}\n" + "assertTrue(ok);\n");
    }

    public final void testTestFramework() throws Exception {
        try {
            this.runTest("assertEquals(0, 1);");
        }
        catch (AssertionFailedError e) {
            CajitaTest.assertEquals((String)"Expected <0> (Number) but was <1> (Number)", (String)e.getMessage());
            return;
        }
        CajitaTest.fail((String)"Did not raise");
    }

    protected void runTest(String code) throws Exception {
        this.mq.getMessages().clear();
        RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/plugin/console-stubs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/log-to-console.js"), new Executor.Input(code, this.getName() + "-test"));
        this.assertNoErrors();
    }
}

