/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.job.MultiTenancyJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecountActiveUserJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.RecountActiveUserJob");

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return RecountActiveUserTask.class;
    }

    public class RecountActiveUserTask
    extends MultiTenancyJob.MultiTenancyTask {
        public RecountActiveUserTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)RecountActiveUserJob.this, context, repoName);
        }

        public void run() {
            block5: {
                super.run();
                try {
                    int days;
                    JobDataMap jdatamap;
                    String lastPost;
                    ForumService forumService = (ForumService)this.container.getComponentInstanceOfType(ForumService.class);
                    if (forumService != null && (lastPost = (jdatamap = this.context.getJobDetail().getJobDataMap()).getString("lastPost")) != null && lastPost.length() > 0 && (days = Integer.parseInt(lastPost)) > 0) {
                        long oneDay = 86400000L;
                        Calendar calendar = GregorianCalendar.getInstance();
                        long currentDay = calendar.getTimeInMillis();
                        calendar.setTimeInMillis(currentDay -= (long)days * oneDay);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
                        forumService.evaluateActiveUsers(stringBuilder.toString());
                        if (log_.isDebugEnabled()) {
                            log_.debug((Object)"\n\n The RecoundActiveUserJob have been done");
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    log_.debug((Object)"Value of days is not Integer number.", (Throwable)nfe);
                }
                catch (Exception e) {
                    if (!log_.isDebugEnabled()) break block5;
                    log_.debug((Object)("\n\n The have exception " + e.getMessage()));
                }
            }
        }
    }
}

