/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Bayeux;
import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.DataFilter;
import dojox.cometd.Extension;
import dojox.cometd.Listener;
import dojox.cometd.Message;
import dojox.cometd.SecurityPolicy;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.JSONPTransport;
import org.mortbay.cometd.JSONTransport;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.cometd.MessagePool;
import org.mortbay.cometd.Transport;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBayeux
extends MessagePool
implements Bayeux {
    public static final ChannelId META_ID = new ChannelId("/meta");
    public static final ChannelId META_CONNECT_ID = new ChannelId("/meta/connect");
    public static final ChannelId META_CLIENT_ID = new ChannelId("/meta/client");
    public static final ChannelId META_DISCONNECT_ID = new ChannelId("/meta/disconnect");
    public static final ChannelId META_HANDSHAKE_ID = new ChannelId("/meta/handshake");
    public static final ChannelId META_PING_ID = new ChannelId("/meta/ping");
    public static final ChannelId META_STATUS_ID = new ChannelId("/meta/status");
    public static final ChannelId META_SUBSCRIBE_ID = new ChannelId("/meta/subscribe");
    public static final ChannelId META_UNSUBSCRIBE_ID = new ChannelId("/meta/unsubscribe");
    private static final Map<String, Object> EXT_JSON_COMMENTED = new HashMap<String, Object>(2){
        {
            this.put("json-comment-filtered", Boolean.TRUE);
        }
    };
    private HashMap<String, Handler> _handlers = new HashMap();
    private ChannelImpl _root = new ChannelImpl("/", this);
    private ConcurrentHashMap<String, ClientImpl> _clients = new ConcurrentHashMap();
    protected SecurityPolicy _securityPolicy = new DefaultPolicy();
    protected Object _advice;
    protected int _adviceVersion = 0;
    protected Object _unknownAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");
    protected int _logLevel;
    protected long _timeout = 240000L;
    protected long _interval = 0L;
    protected long _maxInterval = 30000L;
    protected boolean _JSONCommented;
    protected boolean _initialized;
    protected ConcurrentHashMap<String, List<String>> _browser2client = new ConcurrentHashMap();
    protected int _multiFrameInterval = -1;
    protected JSON.Literal _multiFrameAdvice;
    protected boolean _directDeliver = true;
    protected boolean _requestAvailable;
    protected ThreadLocal<HttpServletRequest> _request = new ThreadLocal();
    transient ServletContext _context;
    transient Random _random;
    transient ConcurrentHashMap<String, ChannelId> _channelIdCache;
    protected Handler _publishHandler;
    protected Handler _metaPublishHandler;
    protected List<Extension> _extensions = new CopyOnWriteArrayList<Extension>();
    protected JSON.Literal _transports = new JSON.Literal("[\"long-polling\",\"callback-polling\"]");

    protected AbstractBayeux() {
        this._publishHandler = new PublishHandler();
        this._metaPublishHandler = new MetaPublishHandler();
        this._handlers.put("/meta/handshake", new HandshakeHandler());
        this._handlers.put("/meta/connect", new ConnectHandler());
        this._handlers.put("/meta/disconnect", new DisconnectHandler());
        this._handlers.put("/meta/subscribe", new SubscribeHandler());
        this._handlers.put("/meta/unsubscribe", new UnsubscribeHandler());
        this._handlers.put("/meta/ping", new PingHandler());
        this.setTimeout(this.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(String channels, DataFilter filter) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ChannelImpl channel = (ChannelImpl)this.getChannel(channels, true);
            channel.addDataFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(String channels, DataFilter filter) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ChannelImpl channel = (ChannelImpl)this.getChannel(channels, false);
            if (channel != null) {
                channel.removeDataFilter(filter);
            }
        }
    }

    public void addExtension(Extension ext) {
        this._extensions.add(ext);
    }

    public List<Extension> getExtensions() {
        return this._extensions;
    }

    public void removeExtension(Extension ext) {
        this._extensions.remove(ext);
    }

    public ChannelImpl getChannel(ChannelId id) {
        return this._root.getChild(id);
    }

    public ChannelImpl getChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this._root.getChild(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String id, boolean create) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ChannelImpl channel = this.getChannel(id);
            if (channel == null && create) {
                channel = new ChannelImpl(id, this);
                this._root.addChild(channel);
                if (this.isLogInfo()) {
                    this.logInfo("newChannel: " + channel);
                }
            }
            return channel;
        }
    }

    public ChannelId getChannelId(String id) {
        ChannelId cid = this._channelIdCache.get(id);
        if (cid == null) {
            cid = new ChannelId(id);
            this._channelIdCache.put(id, cid);
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient(String client_id) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            if (client_id == null) {
                return null;
            }
            Client client = this._clients.get(client_id);
            return client;
        }
    }

    public Set<String> getClientIDs() {
        return this._clients.keySet();
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._securityPolicy;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public boolean isDirectDeliver() {
        return this._directDeliver;
    }

    public void setDirectDeliver(boolean directDeliver) {
        this._directDeliver = directDeliver;
    }

    public String handle(ClientImpl client, Transport transport, Message message) throws IOException {
        String channel_id = message.getChannel();
        Handler handler = this._handlers.get(channel_id);
        if (handler != null) {
            ListIterator<Extension> iter = this._extensions.listIterator(this._extensions.size());
            while (iter.hasPrevious()) {
                message = iter.previous().rcvMeta(message);
            }
            handler.handle(client, transport, message);
            this._metaPublishHandler.handle(client, transport, message);
        } else if (channel_id.startsWith("/meta/")) {
            ListIterator<Extension> iter = this._extensions.listIterator(this._extensions.size());
            while (iter.hasPrevious()) {
                message = iter.previous().rcvMeta(message);
            }
            this._metaPublishHandler.handle(client, transport, message);
        } else {
            handler = this._publishHandler;
            ListIterator<Extension> iter = this._extensions.listIterator(this._extensions.size());
            while (iter.hasPrevious()) {
                message = iter.previous().rcv(message);
            }
            handler.handle(client, transport, message);
        }
        return channel_id;
    }

    public boolean hasChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        return this._root.getChild(cid) != null;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isJSONCommented() {
        return this._JSONCommented;
    }

    public boolean isLogDebug() {
        return this._logLevel > 1;
    }

    public boolean isLogInfo() {
        return this._logLevel > 0;
    }

    public void logDebug(String message) {
        if (this._logLevel > 1) {
            this._context.log(message);
        }
    }

    public void logDebug(String message, Throwable th) {
        if (this._logLevel > 1) {
            this._context.log(message, th);
        }
    }

    public void logWarn(String message, Throwable th) {
        this._context.log(message + ": " + th.toString());
    }

    public void logWarn(String message) {
        this._context.log(message);
    }

    public void logInfo(String message) {
        if (this._logLevel > 0) {
            this._context.log(message);
        }
    }

    public Client newClient(String idPrefix) {
        ClientImpl client = new ClientImpl(this, idPrefix);
        return client;
    }

    public Client newClient(String idPrefix, Listener listener) {
        ClientImpl client = new ClientImpl(this, idPrefix);
        client.setListener(listener);
        return client;
    }

    public abstract ClientImpl newRemoteClient();

    public Transport newTransport(ClientImpl client, Map<?, ?> message) {
        if (this.isLogDebug()) {
            this.logDebug("newTransport: client=" + client + ",message=" + message);
        }
        AbstractTransport result = null;
        try {
            String jsonp;
            String type;
            String string = type = client == null ? null : client.getConnectionType();
            if (type == null) {
                type = (String)message.get("connectionType");
            }
            result = "callback-polling".equals(type) || type == null ? ((jsonp = (String)message.get("jsonp")) != null ? new JSONPTransport(client != null && client.isJSONCommented(), jsonp) : new JSONTransport(client != null && client.isJSONCommented())) : new JSONTransport(client != null && client.isJSONCommented());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isLogDebug()) {
            this.logDebug("newTransport: result=" + result);
        }
        return result;
    }

    protected void doPublish(ChannelId to, Client from, Object data, String msgId) {
        MessageImpl msg = this.newMessage();
        msg.put("channel", to.toString());
        if (msgId == null) {
            long id = ((Object)msg).hashCode() ^ (to == null ? 0 : to.hashCode()) ^ (from == null ? 0 : from.hashCode());
            id = id < 0L ? -id : id;
            msg.put("id", Long.toString(id, 36));
        } else {
            msg.put("id", msgId);
        }
        msg.put("data", data);
        for (Extension e : this._extensions) {
            msg = e.send((Message)msg);
        }
        this._root.doDelivery(to, from, msg);
        msg.decRef();
    }

    public void publish(Client fromClient, String toChannelId, Object data, String msgId) {
        this.doPublish(this.getChannelId(toChannelId), fromClient, data, msgId);
    }

    public void deliver(Client fromClient, Client toClient, String toChannel, Message message) {
        if (toChannel != null) {
            message.put((Object)"channel", (Object)toChannel);
        }
        if (toClient != null) {
            toClient.deliver(fromClient, message);
        }
    }

    public boolean removeChannel(ChannelId channelId) {
        return false;
    }

    protected String newClientId(long variation, String idPrefix) {
        if (idPrefix == null) {
            return Long.toString(this.getRandom(), 36) + Long.toString(variation, 36);
        }
        return idPrefix + "_" + Long.toString(this.getRandom(), 36);
    }

    protected void addClient(ClientImpl client, String idPrefix) {
        String id;
        ClientImpl other;
        do {
            id = this.newClientId(client.hashCode(), idPrefix);
            client.setId(id);
        } while ((other = this._clients.putIfAbsent(id, client)) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client removeClient(String client_id) {
        ClientImpl client;
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            if (client_id == null) {
                return null;
            }
            client = this._clients.remove(client_id);
        }
        if (client != null) {
            client.unsubscribeAll();
        }
        return client;
    }

    public void setMaxInterval(long ms) {
        this._maxInterval = ms;
    }

    public void setJSONCommented(boolean commented) {
        this._JSONCommented = commented;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._securityPolicy = securityPolicy;
    }

    public void setTimeout(long ms) {
        this._timeout = ms;
        this.generateAdvice();
    }

    public void setInterval(long ms) {
        this._interval = ms;
        this.generateAdvice();
    }

    void generateAdvice() {
        this.setAdvice(new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + this.getInterval() + ",\"timeout\":" + this.getTimeout() + "}"));
    }

    public boolean isRequestAvailable() {
        return this._requestAvailable;
    }

    public void setRequestAvailable(boolean requestAvailable) {
        this._requestAvailable = requestAvailable;
    }

    public HttpServletRequest getCurrentRequest() {
        return this._request.get();
    }

    void setCurrentRequest(HttpServletRequest request) {
        this._request.set(request);
    }

    public void subscribe(String toChannel, Client subscriber) {
        ChannelImpl channel = (ChannelImpl)this.getChannel(toChannel, true);
        if (channel != null) {
            channel.subscribe(subscriber);
        }
    }

    public void unsubscribe(String toChannel, Client subscriber) {
        ChannelImpl channel = this.getChannel(toChannel);
        if (channel != null) {
            channel.unsubscribe(subscriber);
        }
    }

    public int getMultiFrameInterval() {
        return this._multiFrameInterval;
    }

    public void setMultiFrameInterval(int multiFrameInterval) {
        this._multiFrameInterval = multiFrameInterval;
        this._multiFrameAdvice = multiFrameInterval > 0 ? new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + this._multiFrameInterval + ",\"multiple-clients\":true,\"timeout\":" + this.getTimeout() + "}") : new JSON.Literal("{\"reconnect\":\"none\",\"multiple-clients\":true,\"timeout\":" + this.getTimeout() + "}");
    }

    public Object getAdvice() {
        return this._advice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdvice(Object advice) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            this._advice = advice;
            ++this._adviceVersion;
        }
    }

    public Collection<Channel> getChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        this._root.getChannels(channels);
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Client> getClients() {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            return new ArrayList<Client>(this._clients.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasClient(String clientId) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            if (clientId == null) {
                return false;
            }
            return this._clients.containsKey(clientId);
        }
    }

    public Channel removeChannel(String channelId) {
        ChannelImpl channel = this.getChannel(channelId);
        channel.remove();
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ServletContext context) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            this._initialized = true;
            this._context = context;
            try {
                this._random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                context.log("Could not get secure random for ID generation", (Throwable)e);
                this._random = new Random();
            }
            this._random.setSeed(this._random.nextLong() ^ (long)this.hashCode() ^ (long)(context.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
            this._channelIdCache = new ConcurrentHashMap();
            this._root.addChild(new ServiceChannel("/service"));
        }
    }

    long getRandom() {
        long l = this._random.nextLong();
        return l < 0L ? -l : l;
    }

    void clientOnBrowser(String browserId, String clientId) {
        CopyOnWriteArrayList<String> new_clients;
        CopyOnWriteArrayList<String> clients = this._browser2client.get(browserId);
        if (clients == null && (clients = (CopyOnWriteArrayList<String>)this._browser2client.putIfAbsent(browserId, new_clients = new CopyOnWriteArrayList<String>())) == null) {
            clients = new_clients;
        }
        clients.add(clientId);
    }

    void clientOffBrowser(String browserId, String clientId) {
        List<String> clients = this._browser2client.get(browserId);
        if (clients != null) {
            clients.remove(clientId);
        }
    }

    List<String> clientsOnBrowser(String browserId) {
        List<String> clients = this._browser2client.get(browserId);
        if (clients == null) {
            return Collections.emptyList();
        }
        return clients;
    }

    protected class ServiceChannel
    extends ChannelImpl {
        ServiceChannel(String id) {
            super(id, AbstractBayeux.this);
        }

        public void addChild(ChannelImpl channel) {
            super.addChild(channel);
            this.setPersistent(true);
        }

        public void subscribe(Client client) {
            if (client.isLocal()) {
                super.subscribe(client);
            }
        }
    }

    protected class PingHandler
    extends Handler {
        protected PingHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_PING_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/ping");
            reply.put("successful", Boolean.TRUE);
            String id = message.getId();
            if (id != null) {
                reply.put("id", id.toString());
            }
            for (Extension e : AbstractBayeux.this._extensions) {
                reply = e.sendMeta((Message)reply);
            }
            transport.send(reply);
        }
    }

    protected class UnsubscribeHandler
    extends Handler {
        protected UnsubscribeHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_UNSUBSCRIBE_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, "/meta/unsubscribe");
                return;
            }
            String channel_id = (String)message.get((Object)"subscription");
            ChannelImpl channel = AbstractBayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.unsubscribe(client);
            }
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/unsubscribe");
            if (channel != null) {
                channel.unsubscribe(client);
                reply.put("subscription", channel.getId());
                reply.put("successful", Boolean.TRUE);
            } else {
                reply.put("successful", Boolean.FALSE);
            }
            String id = message.getId();
            if (id != null) {
                reply.put("id", id.toString());
            }
            for (Extension e : AbstractBayeux.this._extensions) {
                reply = e.sendMeta((Message)reply);
            }
            transport.send(reply);
        }
    }

    protected class SubscribeHandler
    extends Handler {
        protected SubscribeHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_SUBSCRIBE_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, "/meta/subscribe");
                return;
            }
            String subscribe_id = (String)message.get((Object)"subscription");
            if (subscribe_id == null) {
                subscribe_id = Long.toString(AbstractBayeux.this.getRandom(), 36);
                while (AbstractBayeux.this.getChannel(subscribe_id) != null) {
                    subscribe_id = Long.toString(AbstractBayeux.this.getRandom(), 36);
                }
            }
            ChannelId cid = null;
            boolean can_subscribe = false;
            if (subscribe_id.startsWith("/service/")) {
                can_subscribe = true;
            } else if (subscribe_id.startsWith("/meta/")) {
                can_subscribe = false;
            } else {
                cid = AbstractBayeux.this.getChannelId(subscribe_id);
                can_subscribe = AbstractBayeux.this._securityPolicy.canSubscribe((Client)client, subscribe_id, message);
            }
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/subscribe");
            reply.put("subscription", subscribe_id);
            if (can_subscribe) {
                if (cid != null) {
                    ChannelImpl channel = AbstractBayeux.this.getChannel(cid);
                    if (channel == null && AbstractBayeux.this._securityPolicy.canCreate((Client)client, subscribe_id, message)) {
                        channel = (ChannelImpl)AbstractBayeux.this.getChannel(subscribe_id, true);
                    }
                    if (channel != null) {
                        channel.subscribe(client);
                    } else {
                        can_subscribe = false;
                    }
                }
                if (can_subscribe) {
                    reply.put("successful", Boolean.TRUE);
                } else {
                    reply.put("successful", Boolean.FALSE);
                    reply.put("error", "403::cannot create");
                }
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::cannot subscribe");
            }
            String id = message.getId();
            if (id != null) {
                reply.put("id", id.toString());
            }
            for (Extension e : AbstractBayeux.this._extensions) {
                reply = e.sendMeta((Message)reply);
            }
            transport.send(reply);
        }
    }

    protected class MetaPublishHandler
    extends Handler {
        protected MetaPublishHandler() {
        }

        ChannelId getMetaChannelId() {
            return null;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            String channel_id = message.getChannel();
            if (client == null && !"/meta/handshake".equals(channel_id)) {
                return;
            }
            if (AbstractBayeux.this._securityPolicy.canPublish((Client)client, channel_id, message)) {
                AbstractBayeux.this._root.doDelivery(AbstractBayeux.this.getChannelId(channel_id), client, message);
            }
        }
    }

    protected class PublishHandler
    extends Handler {
        protected PublishHandler() {
        }

        ChannelId getMetaChannelId() {
            return null;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            String channel_id = message.getChannel();
            if (client == null && message.containsKey((Object)"clientId")) {
                this.unknownClient(transport, channel_id);
                return;
            }
            String id = message.getId();
            ChannelId cid = AbstractBayeux.this.getChannelId(channel_id);
            Object data = message.get((Object)"data");
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", channel_id);
            if (id != null) {
                reply.put("id", id.toString());
            }
            if (data != null && AbstractBayeux.this._securityPolicy.canPublish((Client)client, channel_id, message)) {
                reply.put("successful", Boolean.TRUE);
                for (Extension e : AbstractBayeux.this._extensions) {
                    reply = e.sendMeta((Message)reply);
                }
                transport.send(reply);
                if (AbstractBayeux.this._directDeliver) {
                    message.remove((Object)"clientId");
                    for (Extension e : AbstractBayeux.this._extensions) {
                        message = e.send(message);
                    }
                    AbstractBayeux.this._root.doDelivery(cid, client, message);
                } else {
                    AbstractBayeux.this.doPublish(cid, client, data, id == null ? null : id.toString());
                }
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::Publish denied");
                for (Extension e : AbstractBayeux.this._extensions) {
                    reply = e.sendMeta((Message)reply);
                }
                transport.send(reply);
            }
        }
    }

    protected class HandshakeHandler
    extends Handler {
        protected HandshakeHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_HANDSHAKE_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            String id;
            if (client != null) {
                throw new IllegalStateException();
            }
            if (AbstractBayeux.this._securityPolicy != null && !AbstractBayeux.this._securityPolicy.canHandshake(message)) {
                MessageImpl reply = AbstractBayeux.this.newMessage(message);
                reply.put("channel", "/meta/handshake");
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::Handshake denied");
                for (Extension e : AbstractBayeux.this._extensions) {
                    reply = e.sendMeta((Message)reply);
                }
                transport.send(reply);
                return;
            }
            client = AbstractBayeux.this.newRemoteClient();
            Map ext = (Map)message.get((Object)"ext");
            boolean commented = AbstractBayeux.this._JSONCommented && ext != null && Boolean.TRUE.equals(ext.get("json-comment-filtered"));
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/handshake");
            reply.put("version", "1.0");
            reply.put("minimumVersion", "0.9");
            if (AbstractBayeux.this.isJSONCommented()) {
                reply.put("ext", EXT_JSON_COMMENTED);
            }
            if (client != null) {
                reply.put("supportedConnectionTypes", AbstractBayeux.this._transports);
                reply.put("successful", Boolean.TRUE);
                reply.put("clientId", client.getId());
                if (AbstractBayeux.this._advice != null) {
                    reply.put("advice", AbstractBayeux.this._advice);
                }
                client.setJSONCommented(commented);
                transport.setJSONCommented(commented);
            } else {
                reply.put("successful", Boolean.FALSE);
                if (AbstractBayeux.this._advice != null) {
                    reply.put("advice", AbstractBayeux.this._advice);
                }
            }
            if (AbstractBayeux.this.isLogDebug()) {
                AbstractBayeux.this.logDebug("handshake.handle: reply=" + reply);
            }
            if ((id = message.getId()) != null) {
                reply.put("id", id.toString());
            }
            for (Extension e : AbstractBayeux.this._extensions) {
                reply = e.sendMeta((Message)reply);
            }
            transport.send(reply);
        }
    }

    protected class DisconnectHandler
    extends Handler {
        protected DisconnectHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_DISCONNECT_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            if (client == null) {
                this.unknownClient(transport, "/meta/disconnect");
                return;
            }
            if (AbstractBayeux.this.isLogInfo()) {
                AbstractBayeux.this.logInfo("Disconnect " + client.getId());
            }
            client.remove(false);
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/disconnect");
            reply.put("successful", Boolean.TRUE);
            String id = message.getId();
            if (id != null) {
                reply.put("id", id.toString());
            }
            for (Extension e : AbstractBayeux.this._extensions) {
                reply = e.sendMeta((Message)reply);
            }
            Message pollReply = transport.getPollReply();
            if (pollReply != null) {
                for (Extension e : AbstractBayeux.this._extensions) {
                    pollReply = e.sendMeta(pollReply);
                }
                transport.send(pollReply);
                transport.setPollReply(null);
            }
            transport.send(reply);
        }
    }

    protected class ConnectHandler
    extends Handler {
        protected String _metaChannel;

        protected ConnectHandler() {
            this._metaChannel = "/meta/connect";
        }

        ChannelId getMetaChannelId() {
            return META_CONNECT_ID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            Object clients;
            int count;
            Object advice;
            if (client == null) {
                this.unknownClient(transport, this._metaChannel);
                return;
            }
            String type = client.getConnectionType();
            boolean polling = true;
            if (type == null) {
                type = (String)message.get((Object)"connectionType");
                client.setConnectionType(type);
                polling = false;
            }
            if ((advice = message.get((Object)"advice")) != null) {
                Long timeout = (Long)((Map)advice).get("timeout");
                if (timeout != null && timeout > 0L) {
                    client.setTimeout(timeout);
                } else {
                    client.setTimeout(0L);
                }
            } else {
                client.setTimeout(0L);
            }
            advice = null;
            if (polling && AbstractBayeux.this._multiFrameInterval > 0 && client.getBrowserId() != null && (count = (clients = AbstractBayeux.this.clientsOnBrowser(client.getBrowserId())).size()) > 1) {
                polling = ((String)clients.get(0)).equals(client.getId());
                advice = AbstractBayeux.this._multiFrameAdvice;
                client.setAdviceVersion(-1);
            }
            clients = this;
            synchronized (clients) {
                if (client.getAdviceVersion() != AbstractBayeux.this._adviceVersion && (client.getAdviceVersion() >= 0 || advice == null)) {
                    advice = AbstractBayeux.this._advice;
                    client.setAdviceVersion(AbstractBayeux.this._adviceVersion);
                }
            }
            String id = message.getId();
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/connect");
            reply.put("successful", Boolean.TRUE);
            if (advice != null) {
                reply.put("advice", advice);
            }
            if (id != null) {
                reply.put("id", id);
            }
            if (polling) {
                transport.setPollReply(reply);
            } else {
                for (Extension e : AbstractBayeux.this._extensions) {
                    reply = e.sendMeta((Message)reply);
                }
                transport.send(reply);
            }
        }
    }

    protected abstract class Handler {
        protected Handler() {
        }

        abstract void handle(ClientImpl var1, Transport var2, Message var3) throws IOException;

        abstract ChannelId getMetaChannelId();

        void unknownClient(Transport transport, String channel) throws IOException {
            MessageImpl reply = AbstractBayeux.this.newMessage();
            reply.put("channel", (Object)channel);
            reply.put("successful", (Object)Boolean.FALSE);
            reply.put("error", (Object)"402::Unknown client");
            reply.put("advice", (Object)new JSON.Literal("{\"reconnect\":\"handshake\"}"));
            transport.send(reply);
        }
    }

    public static class DefaultPolicy
    implements SecurityPolicy {
        public boolean canHandshake(Message message) {
            return true;
        }

        public boolean canCreate(Client client, String channel, Message message) {
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canSubscribe(Client client, String channel, Message message) {
            if (client != null && ("/**".equals(channel) || "/*".equals(channel))) {
                return false;
            }
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canPublish(Client client, String channel, Message message) {
            return client != null || client == null && "/meta/handshake".equals(channel);
        }
    }
}

