/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Executor;
import com.google.caja.util.RhinoAsserts;
import com.google.caja.util.RhinoTestBed;
import junit.framework.TestCase;

public class RhinoAssertsTest
extends TestCase {
    public final void testString() {
        this.assertStructuralForm("\"\"", "''");
        this.assertStructuralForm("\"foo\"", "'foo'");
        this.assertStructuralForm("\"foo\\nbar\"", "'foo\\nbar'");
    }

    public final void testNumbers() {
        this.assertStructuralForm("0.0", "0");
        this.assertStructuralForm("-1.0", "-1");
        this.assertStructuralForm("1.0", "+1");
        this.assertStructuralForm("0.1", ".1");
        this.assertStructuralForm("3.141592654", "3.141592654");
        this.assertStructuralForm("NaN", "NaN");
        this.assertStructuralForm("-Infinity", "-Infinity");
    }

    public final void testBooleans() {
        this.assertStructuralForm("true", "true");
        this.assertStructuralForm("false", "false");
    }

    public final void testNulls() {
        this.assertStructuralForm("null", "null");
        this.assertStructuralForm("undefined", "undefined");
    }

    public final void testArrays() {
        this.assertStructuralForm("[]", "[]");
        this.assertStructuralForm("[1.0, 2.0, 3.0]", "[1, 2, 3]");
        this.assertStructuralForm("[[]]", "[[]]");
        this.assertStructuralForm("[1.0, 2.0, [3.0], null]", "[1, 2, [3], null]");
    }

    public final void testObjects() {
        this.assertStructuralForm("{}", "({})");
        this.assertStructuralForm("{\"a\": {\"b\": null}}", "({ a: { b: null } })");
        this.assertStructuralForm("{\"a\": 4.0, \"b\": null}", "({ b: null, a: 4 })");
        this.assertStructuralForm("{\"0\": \"hi\", \"2\": \"there\", \"1.5\": null, \"length\": 4.0}", "({ length: 4, 2: 'there', 0: 'hi', 1.5: null })");
    }

    public final void testObjectGraphCycles() {
        this.assertStructuralForm("#1=[#1#]", "(function () { var a = []; a.push(a); return a; })()");
        this.assertStructuralForm("#1=[#1#, [3.0]]", "(function () { var a = []; a.push(a, [3]); return a; })()");
        this.assertStructuralForm("{\"x\": #1=[#1#, [3.0]]}", "(function () { var a = []; a.push(a, [3]); return { x: a }; })()");
        this.assertStructuralForm("#1=[#2={\"x\": #1#, \"y\": #2#}, [], #1#, \"foo\", \"foo\"]", "(function () {  var a = [],      b = { x: a };  a.push(b, [], a, 'foo', 'foo');  b.y = b;  return a;})()");
    }

    public final void testBuiltinObjs() {
        this.assertIndeterminateStructuralForm("(function () {})");
        this.assertIndeterminateStructuralForm("(new Date(0))");
        this.assertIndeterminateStructuralForm("(function () { function Array() { } return new Array(); })()");
        this.assertIndeterminateStructuralForm("java.lang.System.err");
    }

    private void assertStructuralForm(String structuralForm, String js) {
        Object result = RhinoTestBed.runJs(new Executor.Input(js, this.getName()));
        RhinoAssertsTest.assertEquals((String)structuralForm, (String)RhinoAsserts.structuralForm(result));
    }

    private void assertIndeterminateStructuralForm(String js) {
        Object result = RhinoTestBed.runJs(new Executor.Input(js, this.getName()));
        try {
            RhinoAsserts.structuralForm(result);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        RhinoAssertsTest.fail((String)("`" + js + "` should not have a structural form"));
    }
}

