/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.xml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomUtil {
    private DomUtil() {
    }

    public static Node getFirstNamedChildNode(Node root, String nodeName) {
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!current.getNodeName().equalsIgnoreCase(nodeName)) continue;
            return current;
        }
        return null;
    }

    public static Node getLastNamedChildNode(Node root, String nodeName) {
        for (Node current = root.getLastChild(); current != null; current = current.getPreviousSibling()) {
            if (!current.getNodeName().equalsIgnoreCase(nodeName)) continue;
            return current;
        }
        return null;
    }

    public static List<Element> getElementsByTagNameCaseInsensitive(Document doc, final Set<String> lowerCaseNames) {
        ArrayList result = Lists.newArrayList();
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NodeFilter(){

            public short acceptNode(Node n) {
                if (lowerCaseNames.contains(n.getNodeName().toLowerCase())) {
                    return 1;
                }
                return 2;
            }
        }, false);
        Node n = nodeIterator.nextNode();
        while (n != null) {
            result.add((Element)n);
            n = nodeIterator.nextNode();
        }
        return result;
    }
}

