/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.wsqa.httpclient.Suite;
import org.exoplatform.wsqa.httpclient.SuiteExecuteContext;
import org.exoplatform.wsqa.httpclient.SuiteListener;
import org.exoplatform.wsqa.httpclient.WebUnit;
import org.exoplatform.wsqa.httpclient.WebUnitExecuteContext;
import org.exoplatform.wsqa.httpclient.WebUnitListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClient {
    private String id_;
    private String suiteName_ = "Default";
    private String scheme_ = "http://";
    private String host_ = "192.168.1.29";
    private int port_ = 8080;
    private String protocol_ = "HTTP/1.1";
    private String cookie_ = "JSESSIONID=AAF6D8E0FE36B9874D1225BFFE4D2E6D";
    private List<WebUnitListener> webUnitListeners_ = new ArrayList<WebUnitListener>();
    private List<SuiteListener> suiteListeners_ = new ArrayList<SuiteListener>();
    private Map<String, String> defaultRequestHeaders_ = new HashMap<String, String>();

    public HttpClient() {
        this.id_ = Integer.toString(this.hashCode());
    }

    public HttpClient(String suiteName) {
        this.suiteName_ = suiteName;
        this.id_ = Integer.toString(this.hashCode());
    }

    public String getId() {
        return this.id_;
    }

    public String getSuiteName() {
        return this.suiteName_;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public String getHost() {
        return this.host_;
    }

    public void setHost(String host) {
        this.host_ = host;
    }

    public int getPort() {
        return this.port_;
    }

    public void setPort(int port) {
        this.port_ = port;
    }

    public String getProtocol() {
        return this.protocol_;
    }

    public void add(WebUnitListener listener) {
        this.webUnitListeners_.add(listener);
    }

    public void add(SuiteListener listener) {
        this.suiteListeners_.add(listener);
    }

    public Map<String, String> getDefaultRequestHeader() {
        return this.defaultRequestHeaders_;
    }

    public String getCookie() {
        return this.cookie_;
    }

    public void setCookie(String s) {
        this.cookie_ = s;
    }

    public void execute(Suite suite) throws Exception {
        List<WebUnit> units = suite.getWebUnits();
        SuiteExecuteContext context = new SuiteExecuteContext();
        for (SuiteListener listener : this.suiteListeners_) {
            listener.onPreExecute(suite, context);
        }
        context.setStartTime(System.currentTimeMillis());
        for (WebUnit unit : units) {
            this.execute(unit);
        }
        context.setEndTime(System.currentTimeMillis());
        for (SuiteListener listener : this.suiteListeners_) {
            listener.onPostExecute(suite, context);
        }
        System.gc();
    }

    public WebUnitExecuteContext execute(WebUnit unit) throws Exception {
        WebUnitExecuteContext context = new WebUnitExecuteContext(this);
        for (WebUnitListener listener : this.webUnitListeners_) {
            listener.onPreExecute(unit, context);
        }
        context.setStartTime(System.currentTimeMillis());
        this.execute(unit, context);
        context.setEndTime(System.currentTimeMillis());
        String setCookie = context.getResponse().getHttpResponseHeader().getSetCookie();
        if (setCookie != null) {
            this.setCookie(setCookie);
        }
        for (WebUnitListener listener : this.webUnitListeners_) {
            listener.onPostExecute(unit, context);
        }
        return context;
    }

    protected abstract void execute(WebUnit var1, WebUnitExecuteContext var2) throws Exception;
}

