/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import org.jboss.cache.NodeFactory;
import org.jboss.cache.PessimisticNodeFactory;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.mvcc.MVCCNodeFactory;
import org.jboss.cache.optimistic.OptimisticNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={NodeFactory.class})
public class NodeMetaFactory
extends ComponentFactory {
    @Override
    protected <T> T construct(Class<T> componentType) {
        switch (this.configuration.getNodeLockingScheme()) {
            case MVCC: {
                return componentType.cast(new MVCCNodeFactory());
            }
            case OPTIMISTIC: {
                return componentType.cast(new OptimisticNodeFactory());
            }
            case PESSIMISTIC: {
                return componentType.cast(new PessimisticNodeFactory());
            }
        }
        throw new ConfigurationException("Unknown locking scheme " + (Object)((Object)this.configuration.getNodeLockingScheme()));
    }
}

