/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api;

import java.io.Serializable;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContext
implements Serializable {
    protected final String id;
    private final String applicationName;
    private final String portletName;
    private static final String PREFIX = "/";
    private static final char SEPARATOR = '.';

    PortletContext(String id) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"portlet id", (String)"PortletContext");
        String trimmedId = id.trim();
        if (trimmedId.startsWith(PREFIX)) {
            String compound = trimmedId.substring(1);
            int separator = compound.indexOf(46);
            if (separator != -1) {
                this.portletName = compound.substring(separator + 1).trim();
                this.applicationName = compound.substring(0, separator).trim();
            } else {
                this.portletName = null;
                this.applicationName = null;
            }
        } else {
            this.portletName = null;
            this.applicationName = null;
        }
        this.id = this.portletName == null || this.applicationName == null ? trimmedId : PREFIX + this.applicationName + '.' + this.portletName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PortletContext) {
            PortletContext that = (PortletContext)o;
            return this.id.equals(that.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "PortletContext[" + this.id + "]";
    }

    @Deprecated
    public static PortletContext createPortletContext(String id, byte[] state) {
        if (state != null && state.length > 0) {
            return new StatefulPortletContext<byte[]>(id, PortletStateType.OPAQUE, state);
        }
        return new PortletContext(id);
    }

    @Deprecated
    public static StatefulPortletContext<byte[]> createStatefulPortletContext(String id, byte[] state) {
        return new StatefulPortletContext<byte[]>(id, PortletStateType.OPAQUE, state);
    }

    public static PortletContext createPortletContext(String portletId) {
        return PortletContext.createPortletContext(portletId, (byte[])null);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public static PortletContext createPortletContext(String portletApplicationId, String containerId) {
        return PortletContext.createPortletContext(portletApplicationId + '.' + containerId);
    }
}

