/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;

public abstract class StreamExporter
extends BaseXmlExporter {
    protected final XMLStreamWriter writer;
    protected final boolean exportChildVersionHistory;

    public StreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        this(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse, false);
    }

    public StreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse, boolean exportChildVersionHistory) throws NamespaceException, RepositoryException {
        super(dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse, noRecurse ? 1 : -1);
        this.writer = writer;
        this.exportChildVersionHistory = exportChildVersionHistory;
    }

    public void export(NodeData node) throws RepositoryException, XMLStreamException {
        if (this.writer != null) {
            this.writer.writeStartDocument("UTF-8", "1.0");
            node.accept(this);
            this.writer.writeEndDocument();
            this.writer.close();
        }
    }

    protected void startPrefixMapping() throws RepositoryException, XMLStreamException {
        String[] prefixes;
        for (String prefix : prefixes = this.getNamespaceRegistry().getPrefixes()) {
            if (prefix == null || prefix.length() < 1 || prefix.equals("xml")) continue;
            this.writer.writeNamespace(prefix, this.getNamespaceRegistry().getURI(prefix));
        }
    }
}

