/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.parser.quasiliteral.ES53Rewriter;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.service.AbstractCajolingHandler;
import com.google.caja.service.CajaArguments;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.ServiceMessageType;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHandler
extends AbstractCajolingHandler {
    public JsHandler(BuildInfo buildInfo) {
        super(buildInfo, null, null);
    }

    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, String outputContentType, ContentTypeCheck checker) {
        return checker.check("text/javascript", inputContentType) && checker.check(outputContentType, "text/javascript") && (transform == null || transform.equals((Object)CajolingService.Transform.CAJOLE));
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directive, ContentHandlerArgs args, String inputContentType, String outputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        String moduleCallbackString = CajaArguments.MODULE_CALLBACK.get(args);
        Expression moduleCallback = (Expression)(moduleCallbackString == null ? null : QuasiBuilder.substV(moduleCallbackString, new Object[0]));
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8.name());
            this.cajoleJs(uri, input.getTextualContent(), transform, directive, moduleCallback, writer, mq);
            writer.flush();
        }
        catch (IOException e) {
            throw new UnsupportedContentTypeException();
        }
        return Pair.pair("text/javascript", Charsets.UTF_8.name());
    }

    private void cajoleJs(URI inputUri, CharProducer cp, CajolingService.Transform transform, List<CajolingService.Directive> directive, Expression moduleCallback, Appendable output, MessageQueue mq) {
        InputSource is = new InputSource(inputUri);
        try {
            JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), is);
            Block input = new Parser(tq, mq).parse();
            tq.expectEmpty();
            UncajoledModule ucm = new UncajoledModule(input);
            if (!directive.contains((Object)CajolingService.Directive.ES53)) {
                DefaultValijaRewriter vrw = new DefaultValijaRewriter(mq, false);
                CajitaRewriter crw = new CajitaRewriter(this.buildInfo, mq, false);
                if (transform == null || transform.equals((Object)CajolingService.Transform.CAJOLE) && directive.contains((Object)CajolingService.Directive.CAJITA)) {
                    this.renderAsJavascript((CajoledModule)crw.expand(ucm), moduleCallback, output);
                } else {
                    this.renderAsJavascript((CajoledModule)crw.expand(vrw.expand(ucm)), moduleCallback, output);
                }
            } else {
                ES53Rewriter esrw = new ES53Rewriter(this.buildInfo, mq, false);
                this.renderAsJavascript((CajoledModule)esrw.expand(ucm), moduleCallback, output);
            }
        }
        catch (ParseException e) {
            e.toMessageQueue(mq);
        }
        catch (IOException e) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.IO_ERROR, MessagePart.Factory.valueOf(e.getMessage()));
        }
    }
}

