/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.submit.exec;

import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractRichTextAreaExecutable;

/**
 * Enables or disables the rich text area. When the rich text area is disabled its content is not submitted.
 * 
 * @version $Id: EnableExecutable.java 26786 2010-02-07 16:46:17Z mflorea $
 */
public class EnableExecutable extends AbstractRichTextAreaExecutable
{
    /**
     * Creates a new executable that can be used to enable and disable the specified rich text area.
     * 
     * @param rta the execution target
     */
    public EnableExecutable(RichTextArea rta)
    {
        super(rta);
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractRichTextAreaExecutable#execute(String)
     */
    public boolean execute(String parameter)
    {
        rta.setEnabled(Boolean.parseBoolean(parameter));
        return true;
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractRichTextAreaExecutable#getParameter()
     */
    public String getParameter()
    {
        return Boolean.toString(rta.isEnabled());
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractRichTextAreaExecutable#isEnabled()
     */
    public boolean isEnabled()
    {
        // Always enabled.
        return true;
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractRichTextAreaExecutable#isExecuted()
     */
    public boolean isExecuted()
    {
        return rta.isEnabled();
    }

    /**
     * {@inheritDoc}
     * 
     * @see AbstractRichTextAreaExecutable#isSupported()
     */
    public boolean isSupported()
    {
        // Always supported.
        return true;
    }
}
