/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.parameter.MacroParameterException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroUtils {
    public static List<Block> parseSourceSyntax(ComponentManager componentManager, String content, MacroTransformationContext context) throws MacroExecutionException {
        Parser parser = MacroUtils.getSyntaxParser(componentManager, context);
        try {
            List children;
            List blocks = parser.parse((Reader)new StringReader(content)).getChildren();
            if (context.isInline()) {
                ParserUtils parseUtils = new ParserUtils();
                parseUtils.removeTopLevelParagraph(blocks);
            }
            if (blocks.size() == 1 && blocks.get(0) instanceof ParagraphBlock && (children = ((Block)blocks.get(0)).getChildren()).size() > 0) {
                blocks = children;
            }
            return blocks;
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
    }

    public static void validateNumberParam(String param) throws MacroExecutionException {
        if (param.length() > 0) {
            try {
                if (Integer.valueOf(param) < 0) {
                    throw new MacroExecutionException("The value is too low. The lowest allowed value is 0");
                }
            }
            catch (NumberFormatException e) {
                throw new MacroParameterException("Parameter is not a number");
            }
        }
    }

    private static Parser getSyntaxParser(ComponentManager componentManager, MacroTransformationContext context) throws MacroExecutionException {
        try {
            return (Parser)componentManager.lookup(Parser.class, context.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + context.getSyntax() + "]", (Throwable)e);
        }
    }
}

