/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.section;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.wiki.rendering.macro.section.ColumnStyle;
import org.exoplatform.wiki.rendering.macro.section.SectionMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="section")
public class SectionMacro
extends AbstractMacro<SectionMacroParameters> {
    private static final double TOTAL_WIDTH = 99.9;
    private static final double COLUMN_RIGHT_PADDING_RATE = 1.5;
    private static final String STYLE_TEXT_ALIGN_JUSTIFY = "text-align:justify;";
    private static final String STYLE_CLEAR_BOTH = "clear:both";
    private static final String PARAMETER_STYLE = "style";
    private static final String COLUMN_RIGHT_PADDING_STYLE = "1.5%";
    private static final String DESCRIPTION = "A macro to enclose columned text";
    private static final String MACRO_NAME = "Section";
    @Requirement
    private ComponentManager componentManager;

    public SectionMacro() {
        super(MACRO_NAME, DESCRIPTION, SectionMacroParameters.class);
    }

    public List<Block> execute(SectionMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM parsedDom;
        Parser parser = this.getSyntaxParser(context.getSyntax().toIdString());
        try {
            parsedDom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
        List potentialColumns = parsedDom.getChildrenByType(MacroBlock.class, false);
        int count = this.countColumns(potentialColumns);
        if (count == 0) {
            throw new MacroExecutionException("Section macro expect at least one column macro as first-level children");
        }
        double computedColumnWidth = (99.9 - 1.5 * (double)(count - 1)) / (double)count;
        this.makeColumns(potentialColumns, computedColumnWidth);
        HashMap<String, String> clearFloatsParams = new HashMap<String, String>();
        clearFloatsParams.put(PARAMETER_STYLE, STYLE_CLEAR_BOTH);
        parsedDom.addChild((Block)new GroupBlock(clearFloatsParams));
        HashMap<String, String> sectionParameters = new HashMap<String, String>();
        if (parameters.isJustify()) {
            sectionParameters.put(PARAMETER_STYLE, STYLE_TEXT_ALIGN_JUSTIFY);
        }
        GroupBlock sectionRoot = new GroupBlock(sectionParameters);
        sectionRoot.addChildren(parsedDom.getChildren());
        return Collections.singletonList(sectionRoot);
    }

    private int countColumns(List<MacroBlock> blocks) {
        int result = 0;
        for (MacroBlock maybeColumn : blocks) {
            if (!maybeColumn.getId().equals("column")) continue;
            ++result;
        }
        return result;
    }

    private void makeColumns(List<MacroBlock> blocks, double columnWidth) {
        Iterator<MacroBlock> it = blocks.iterator();
        while (it.hasNext()) {
            MacroBlock probablyColumn = it.next();
            if (!probablyColumn.getId().equals("column")) continue;
            ColumnStyle style = new ColumnStyle();
            style.setWidth(columnWidth + "%");
            if (it.hasNext()) {
                style.setPaddingRight(COLUMN_RIGHT_PADDING_STYLE);
            }
            Map<String, String> params = Collections.singletonMap(PARAMETER_STYLE, style.getStyleAsString());
            GroupBlock colParent = new GroupBlock(new HashMap<String, String>(params));
            colParent.addChild(probablyColumn.clone());
            probablyColumn.getParent().replaceChild((Block)colParent, (Block)probablyColumn);
        }
    }

    protected Parser getSyntaxParser(String syntaxId) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.lookup(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser", (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public int getPriority() {
        return 750;
    }
}

