/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheKey
implements Externalizable,
Comparable<CacheKey> {
    protected String fullId;
    protected int hash;

    public CacheKey() {
    }

    public CacheKey(String id) {
        this(id, id.hashCode());
    }

    public CacheKey(String id, int hash) {
        this.fullId = this.getClass().getSimpleName() + "-" + id;
        this.hash = hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.fullId;
    }

    @Override
    public int compareTo(CacheKey o) {
        return this.fullId.compareTo(o.fullId);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.hash);
        byte[] buf = this.fullId.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hash = in.readInt();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.fullId = new String(buf, "UTF-8");
    }

    public abstract boolean equals(Object var1);
}

